/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.query.filters.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class LogicalFilter
extends Filter {
    private final List<Filter> filters;

    LogicalFilter(String name, Filter ... filters) {
        super(name);
        this.filters = new ArrayList<Filter>(Arrays.asList(filters));
    }

    public LogicalFilter add(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        writer.writeStartArray(this.getName());
        for (Filter filter : this.filters) {
            ExpressionHelper.document(writer, () -> filter.encode(datastore, writer, context));
        }
        writer.writeEndArray();
    }

    @Override
    public Filter entityType(Class<?> type) {
        super.entityType(type);
        for (Filter filter : this.filters) {
            filter.entityType(type);
        }
        return this;
    }

    @Override
    public Filter isValidating(boolean validate) {
        super.isValidating(validate);
        for (Filter filter : this.filters) {
            filter.isValidating(validate);
        }
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getName(), this.filters);
    }
}

