/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Point;
import dev.morphia.Datastore;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.query.filters.Filter;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class NearFilter
extends Filter {
    private Double maxDistance;
    private Double minDistance;
    private CoordinateReferenceSystem crs;

    NearFilter(String filterName, String field, Point point) {
        super(filterName, field, point);
    }

    @MorphiaInternal
    public void applyOpts(Map<?, ?> opts) {
        this.maxDistance = (Double)opts.get("$maxDistance");
        this.minDistance = (Double)opts.get("$minDistance");
    }

    public NearFilter maxDistance(Double maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    public NearFilter minDistance(Double minDistance) {
        this.minDistance = minDistance;
        return this;
    }

    public NearFilter crs(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    @Override
    @MorphiaInternal
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(datastore.getMapper()));
        if (this.isNot()) {
            writer.writeStartDocument("$not");
        }
        writer.writeStartDocument(this.getName());
        writer.writeName("$geometry");
        this.writeUnnamedValue(this.getValue(datastore), datastore, writer, context);
        if (this.maxDistance != null) {
            this.writeNamedValue("$maxDistance", this.maxDistance, datastore, writer, context);
        }
        if (this.minDistance != null) {
            this.writeNamedValue("$minDistance", this.minDistance, datastore, writer, context);
        }
        if (this.crs != null) {
            this.writeNamedValue("crs", this.crs, datastore, writer, context);
        }
        writer.writeEndDocument();
        if (this.isNot()) {
            writer.writeEndDocument();
        }
        writer.writeEndDocument();
    }
}

