/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import com.mongodb.client.model.geojson.Point;
import dev.morphia.Datastore;
import dev.morphia.query.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class PolygonFilter
extends Filter {
    private final Point[] points;

    PolygonFilter(String field, Point[] points) {
        super("$polygon", field, null);
        this.points = points;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(datastore.getMapper()));
        writer.writeStartDocument("$geoWithin");
        writer.writeStartArray("$polygon");
        for (Point point : this.points) {
            writer.writeStartArray();
            for (Double value : point.getPosition().getValues()) {
                writer.writeDouble(value.doubleValue());
            }
            writer.writeEndArray();
        }
        writer.writeEndArray();
        writer.writeEndDocument();
        writer.writeEndDocument();
    }
}

