/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.query.filters.Filter;
import java.util.regex.Pattern;
import org.bson.BsonRegularExpression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class RegexFilter
extends Filter {
    private String options;

    RegexFilter(String field, @Nullable String pattern) {
        super("$regex", field, pattern);
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(datastore.getMapper()));
        if (this.isNot()) {
            writer.writeStartDocument("$not");
        }
        ExpressionHelper.value(datastore, writer, "$regex", new BsonRegularExpression((String)this.getValue()), context);
        ExpressionHelper.value(writer, "$options", this.options);
        if (this.isNot()) {
            writer.writeEndDocument();
        }
        writer.writeEndDocument();
    }

    public RegexFilter options(String options) {
        this.options = options;
        return this;
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public RegexFilter pattern(String pattern) {
        this.setValue(pattern);
        return this;
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public RegexFilter pattern(Pattern pattern) {
        this.setValue(pattern.pattern());
        return this;
    }

    public RegexFilter caseInsensitive() {
        this.add("i");
        return this;
    }

    public RegexFilter extended() {
        this.add("x");
        return this;
    }

    public RegexFilter multiline() {
        this.add("m");
        return this;
    }

    public RegexFilter special() {
        this.add("s");
        return this;
    }

    private void add(String option) {
        if (this.options == null) {
            this.options = "";
        }
        if (!this.options.contains(option)) {
            this.options = this.options + option;
        }
    }
}

