/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import dev.morphia.Datastore;
import dev.morphia.query.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class TextSearchFilter
extends Filter {
    private final String searchText;
    private String language;
    private Boolean caseSensitive;
    private Boolean diacriticSensitive;

    protected TextSearchFilter(String searchText) {
        super("$text");
        this.searchText = searchText;
    }

    public TextSearchFilter caseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public TextSearchFilter diacriticSensitive(Boolean diacriticSensitive) {
        this.diacriticSensitive = diacriticSensitive;
        return this;
    }

    @Override
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.getName());
        this.writeNamedValue("$search", this.searchText, datastore, writer, context);
        if (this.language != null) {
            this.writeNamedValue("$language", this.language, datastore, writer, context);
        }
        if (Boolean.TRUE.equals(this.caseSensitive)) {
            this.writeNamedValue("$caseSensitive", this.caseSensitive, datastore, writer, context);
        }
        if (Boolean.TRUE.equals(this.diacriticSensitive)) {
            this.writeNamedValue("$diacriticSensitive", this.diacriticSensitive, datastore, writer, context);
        }
        writer.writeEndDocument();
    }

    public TextSearchFilter language(String language) {
        this.language = language;
        return this;
    }
}

