/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.internal;

import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.lang.NonNull;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.reader.DocumentReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;

@Deprecated(since="2.0", forRemoval=true)
public class MorphiaKeyCursor<T>
implements MongoCursor<Key<T>> {
    private final MongoCursor<Document> wrapped;
    private final Datastore datastore;
    private final Class<T> clazz;
    private final String collection;

    @MorphiaInternal
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MorphiaKeyCursor(MongoCursor<Document> cursor, Datastore datastore, Class<T> clazz, String collection) {
        this.wrapped = cursor;
        if (this.wrapped == null) {
            throw new IllegalArgumentException("The wrapped cursor can not be null");
        }
        this.datastore = datastore;
        this.clazz = clazz;
        this.collection = collection;
    }

    public void close() {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
    }

    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        return this.wrapped.hasNext();
    }

    @NonNull
    public Key<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.convertItem((Document)this.wrapped.next());
    }

    public int available() {
        return this.wrapped.available();
    }

    public Key<T> tryNext() {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @NonNull
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    private Key<T> convertItem(Document document) {
        Object id = document.get((Object)"_id");
        if (id instanceof Document) {
            id = this.fromDocument(this.clazz, (Document)id);
        }
        return new Key<T>(this.clazz, this.collection, id);
    }

    private <I> I fromDocument(Class<I> type, Document document) {
        Class<Object> aClass = type;
        Mapper mapper = this.datastore.getMapper();
        if (document.containsKey((Object)mapper.getConfig().discriminatorKey())) {
            aClass = mapper.getClass(document);
        }
        DocumentReader reader = new DocumentReader(document);
        return (I)this.datastore.getCodecRegistry().get(aClass).decode((BsonReader)reader, DecoderContext.builder().build());
    }

    public List<Key<T>> toList() {
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        try {
            while (this.wrapped.hasNext()) {
                results.add((Key<T>)this.next());
            }
        }
        finally {
            this.wrapped.close();
        }
        return results;
    }

    public void remove() {
        this.wrapped.remove();
    }
}

