/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.updates;

import dev.morphia.Datastore;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.OperationTarget;
import dev.morphia.query.updates.UpdateOperator;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class SetEntityOperator
extends UpdateOperator {
    @MorphiaInternal
    public SetEntityOperator(Object value) {
        super("$set", "", value);
    }

    @Override
    public OperationTarget toTarget(PathTarget pathTarget) {
        return new OperationTarget(null, this.value()){

            @Override
            public Object encode(Datastore datastore) {
                Object value = SetEntityOperator.this.value();
                EntityModel entityModel = datastore.getMapper().getEntityModel(value.getClass());
                PropertyModel versionProperty = entityModel.getVersionProperty();
                if (versionProperty == null) {
                    return super.encode(datastore);
                }
                Codec codec = datastore.getCodecRegistry().get(value.getClass());
                DocumentWriter writer = new DocumentWriter(datastore.getMapper().getConfig());
                codec.encode((BsonWriter)writer, value, EncoderContext.builder().build());
                Document document = writer.getDocument();
                document.remove((Object)versionProperty.getMappedName());
                return document;
            }
        };
    }
}

