/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.updates;

import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.OperationTarget;
import dev.morphia.query.internal.DatastoreAware;
import dev.morphia.query.updates.UpdateOperator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class SetOnInsertOperator
extends UpdateOperator
implements DatastoreAware {
    private final Map<String, Object> insertValues;
    private DatastoreImpl datastore;

    @MorphiaInternal
    public SetOnInsertOperator(Map<String, Object> values) {
        super("$setOnInsert", "unused", "unused");
        this.insertValues = new LinkedHashMap<String, Object>(values);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setDatastore(DatastoreImpl datastore) {
        this.datastore = datastore;
    }

    @Override
    public OperationTarget toTarget(PathTarget pathTarget) {
        Mapper mapper = pathTarget.mapper();
        EntityModel model = mapper.getEntityModel(pathTarget.root().getType());
        final DocumentWriter writer = new DocumentWriter(mapper.getConfig());
        ExpressionHelper.document(writer, () -> this.insertValues.forEach((key, value) -> {
            PathTarget keyTarget = new PathTarget(mapper, model, (String)key, true);
            writer.writeName(keyTarget.translatedPath());
            Codec valueCodec = this.datastore.getCodecRegistry().get(value.getClass());
            valueCodec.encode((BsonWriter)writer, value, EncoderContext.builder().build());
        }));
        return new OperationTarget(null, null){

            @Override
            public Object encode(Datastore datastore) {
                return writer.getDocument();
            }
        };
    }
}

