/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.updates;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.query.OperationTarget;
import dev.morphia.query.UpdateException;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;

@MorphiaInternal
public class UpdateOperator {
    private final String operator;
    private final String field;
    private Object value;

    protected UpdateOperator(String operator, String field, Object value) {
        this.operator = operator;
        this.field = field;
        this.value = value;
    }

    protected UpdateOperator(String operator, String field, List<?> values) {
        if (values.isEmpty()) {
            throw new UpdateException(Sofia.valuesCannotBeNullOrEmpty(new Locale[0]));
        }
        this.operator = operator;
        this.field = field;
        this.value = values;
    }

    @MorphiaInternal
    public String field() {
        return this.field;
    }

    @MorphiaInternal
    public String operator() {
        return this.operator;
    }

    @MorphiaInternal
    public OperationTarget toTarget(PathTarget pathTarget) {
        return new OperationTarget(pathTarget, this.value());
    }

    @MorphiaInternal
    public Object value() {
        return this.value;
    }

    protected void value(Object value) {
        this.value = value;
    }

    public String toString() {
        return String.format("UpdateOperator{operator='%s', field='%s', value=%s}", this.operator, this.field, this.value);
    }
}

