/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.transactions;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.TransactionBody;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ServerSession;
import dev.morphia.DatastoreImpl;
import dev.morphia.DeleteOptions;
import dev.morphia.InsertManyOptions;
import dev.morphia.InsertOneOptions;
import dev.morphia.ModifyOptions;
import dev.morphia.ReplaceOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.transactions.MorphiaSession;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

@MorphiaInternal
public class MorphiaSessionImpl
extends DatastoreImpl
implements MorphiaSession {
    private final ClientSession session;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MorphiaSessionImpl(DatastoreImpl datastore, ClientSession session) {
        super(datastore);
        this.operations(new TransactionalOperations());
        this.session = session;
    }

    @Nullable
    public ServerAddress getPinnedServerAddress() {
        return this.session.getPinnedServerAddress();
    }

    public boolean hasActiveTransaction() {
        return this.session.hasActiveTransaction();
    }

    public boolean notifyMessageSent() {
        return this.session.notifyMessageSent();
    }

    public void notifyOperationInitiated(Object operation) {
        this.session.notifyOperationInitiated(operation);
    }

    public TransactionOptions getTransactionOptions() {
        return this.session.getTransactionOptions();
    }

    public void startTransaction() {
        this.session.startTransaction();
    }

    public void startTransaction(TransactionOptions transactionOptions) {
        this.session.startTransaction(transactionOptions);
    }

    public void commitTransaction() {
        this.session.commitTransaction();
    }

    public void abortTransaction() {
        this.session.abortTransaction();
    }

    public <T> T withTransaction(TransactionBody<T> transactionBody) {
        return (T)this.session.withTransaction(transactionBody);
    }

    public BsonTimestamp getSnapshotTimestamp() {
        return this.session.getSnapshotTimestamp();
    }

    public <T> T withTransaction(TransactionBody<T> transactionBody, TransactionOptions options) {
        return (T)this.session.withTransaction(transactionBody, options);
    }

    @NonNull
    public ClientSession getSession() {
        return this.session;
    }

    public Object getTransactionContext() {
        return this.session.getTransactionContext();
    }

    public void setTransactionContext(ServerAddress serverAddress, Object o) {
        this.session.setTransactionContext(serverAddress, o);
    }

    public void clearTransactionContext() {
        this.session.clearTransactionContext();
    }

    @Nullable
    public BsonDocument getRecoveryToken() {
        return this.session.getRecoveryToken();
    }

    public void setRecoveryToken(BsonDocument recoveryToken) {
        this.session.setRecoveryToken(recoveryToken);
    }

    public ClientSessionOptions getOptions() {
        return this.session.getOptions();
    }

    public boolean isCausallyConsistent() {
        return this.session.isCausallyConsistent();
    }

    public Object getOriginator() {
        return this.session.getOriginator();
    }

    public ServerSession getServerSession() {
        return this.session.getServerSession();
    }

    public BsonTimestamp getOperationTime() {
        return this.session.getOperationTime();
    }

    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.session.advanceOperationTime(operationTime);
    }

    public void advanceClusterTime(BsonDocument clusterTime) {
        this.session.advanceClusterTime(clusterTime);
    }

    public void setSnapshotTimestamp(BsonTimestamp bsonTimestamp) {
        this.session.setSnapshotTimestamp(bsonTimestamp);
    }

    public BsonDocument getClusterTime() {
        return this.session.getClusterTime();
    }

    public void close() {
        this.session.close();
    }

    private class TransactionalOperations
    extends DatastoreImpl.DatastoreOperations {
        private TransactionalOperations() {
        }

        @Override
        public <T> long countDocuments(MongoCollection<T> collection, Document query, dev.morphia.query.CountOptions options) {
            return collection.countDocuments(MorphiaSessionImpl.this.session, (Bson)query, (CountOptions)options);
        }

        @Override
        public <T> DeleteResult deleteMany(MongoCollection<T> collection, Document queryDocument, DeleteOptions options) {
            return collection.deleteMany(MorphiaSessionImpl.this.session, (Bson)queryDocument, (com.mongodb.client.model.DeleteOptions)options);
        }

        @Override
        public <T> DeleteResult deleteOne(MongoCollection<T> collection, Document queryDocument, DeleteOptions options) {
            return collection.deleteOne(MorphiaSessionImpl.this.session, (Bson)queryDocument, (com.mongodb.client.model.DeleteOptions)options);
        }

        @Override
        public <E> FindIterable<E> find(MongoCollection<E> collection, Document query) {
            return collection.find(MorphiaSessionImpl.this.session, (Bson)query);
        }

        @Override
        public <T> T findOneAndDelete(MongoCollection<T> mongoCollection, Document queryDocument, FindAndDeleteOptions options) {
            return (T)mongoCollection.findOneAndDelete(MorphiaSessionImpl.this.session, (Bson)queryDocument, (FindOneAndDeleteOptions)options);
        }

        @Override
        public <T> T findOneAndUpdate(MongoCollection<T> collection, Document query, Document update, ModifyOptions options) {
            return (T)collection.findOneAndUpdate(MorphiaSessionImpl.this.session, (Bson)query, (Bson)update, (FindOneAndUpdateOptions)options);
        }

        @Override
        public <T> InsertManyResult insertMany(MongoCollection<T> collection, List<T> list, InsertManyOptions options) {
            return collection.insertMany(MorphiaSessionImpl.this.session, list, options.options());
        }

        @Override
        public <T> InsertOneResult insertOne(MongoCollection<T> collection, T entity, InsertOneOptions options) {
            return collection.insertOne(MorphiaSessionImpl.this.session, entity, options.options());
        }

        @Override
        public <T> UpdateResult replaceOne(MongoCollection<T> collection, T entity, Document filter, ReplaceOptions options) {
            return collection.replaceOne(MorphiaSessionImpl.this.session, (Bson)filter, entity, (com.mongodb.client.model.ReplaceOptions)options);
        }

        @Override
        public Document runCommand(Document command) {
            return MorphiaSessionImpl.this.getMongoClient().getDatabase("admin").runCommand(MorphiaSessionImpl.this.session, (Bson)command);
        }

        @Override
        public <T> UpdateResult updateMany(MongoCollection<T> collection, Document queryObject, Document updateOperations, UpdateOptions options) {
            return collection.updateMany(MorphiaSessionImpl.this.session, (Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateMany(MongoCollection<T> collection, Document queryObject, List<Document> updateOperations, UpdateOptions options) {
            return collection.updateMany(MorphiaSessionImpl.this.session, (Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateOne(MongoCollection<T> collection, Document queryObject, Document updateOperations, UpdateOptions options) {
            return collection.updateOne(MorphiaSessionImpl.this.session, (Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }

        @Override
        public <T> UpdateResult updateOne(MongoCollection<T> collection, Document queryObject, List<Document> updateOperations, UpdateOptions options) {
            return collection.updateOne(MorphiaSessionImpl.this.session, (Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }
    }
}

