/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.decoder;

import java.nio.ByteBuffer;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.rules.PrimitiveOctetStringRule;
import org.apache.ldap.common.berlib.asn1.BufferUtils;
import org.apache.ldap.common.message.LdapResult;
import org.apache.ldap.common.message.ResultResponse;

public class ErrorMessageRule
extends PrimitiveOctetStringRule {
    private LdapResult result = null;
    private boolean byPass = false;

    public void tag(int id, boolean isPrimitive, TypeClass typeClass) {
        ResultResponse resp = (ResultResponse)this.getDigester().peek();
        this.result = resp.getLdapResult();
        boolean bl = this.byPass = this.result.getMatchedDn() == null || this.result.getErrorMessage() != null;
        if (!this.byPass) {
            super.tag(id, isPrimitive, typeClass);
        }
    }

    public void length(int length) {
        if (!this.byPass) {
            super.length(length);
        }
    }

    public void value(ByteBuffer buf) {
        if (!this.byPass) {
            super.value(buf);
        }
    }

    public void finish() {
        if (this.isConstructed() || this.byPass) {
            return;
        }
        ByteBuffer buf = this.getAccumulator().drain(0);
        String errorMsg = new String(BufferUtils.getArray(buf));
        this.result.setErrorMessage(errorMsg);
        this.setConstructed(false);
        this.byPass = false;
        this.result = null;
    }
}

