/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.berlib.asn1.encoder.bind;

import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.TagEnum;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.commons.lang.NotImplementedException;
import org.apache.ldap.common.berlib.asn1.LdapTag;
import org.apache.ldap.common.berlib.asn1.encoder.EncoderUtils;
import org.apache.ldap.common.message.BindRequest;

public class BindRequestEncoder {
    public static final BindRequestEncoder INSTANCE = new BindRequestEncoder();

    public TupleNode encode(BindRequest request) {
        DefaultMutableTupleNode top = new DefaultMutableTupleNode(new Tuple());
        top.getTuple().setTag((TagEnum)UniversalTag.SEQUENCE_SEQUENCE_OF, false);
        top.getTuple().setLength(-2);
        DefaultMutableTupleNode child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getMessageId());
        top.addLast(child);
        child.setParent((MutableTupleNode)top);
        DefaultMutableTupleNode bindreq = new DefaultMutableTupleNode(new Tuple());
        bindreq.getTuple().setTag((TagEnum)LdapTag.BIND_REQUEST, false);
        bindreq.getTuple().setLength(-2);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getVersion3() ? 3 : 2);
        bindreq.addLast(child);
        child.setParent((MutableTupleNode)bindreq);
        child = (DefaultMutableTupleNode)EncoderUtils.encode(request.getName());
        bindreq.addLast(child);
        child.setParent((MutableTupleNode)bindreq);
        if (!request.isSimple()) {
            throw new NotImplementedException("SASL not yet implemented!");
        }
        child = (DefaultMutableTupleNode)EncoderUtils.encode((TagEnum)LdapTag.CONTEXT_SPECIFIC_TAG_0, request.getCredentials());
        bindreq.addLast(child);
        child.setParent((MutableTupleNode)bindreq);
        top.addLast(bindreq);
        bindreq.setParent((MutableTupleNode)top);
        return top;
    }
}

