/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1new.ber.Asn1Decoder;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ldap.codec.LdapDecoder;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.util.StringUtils;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderDecoder;
import org.apache.ldap.common.message.spi.ProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixDecoder
implements ProviderDecoder {
    private static Logger log = LoggerFactory.getLogger((Class)TwixDecoder.class);
    private final Provider provider;
    private final LdapMessageContainer ldapMessageContainer;
    private final Asn1Decoder ldapDecoder;
    private DecoderCallback decoderCallback;

    public TwixDecoder(Provider provider) {
        this.provider = provider;
        this.ldapMessageContainer = new LdapMessageContainer();
        this.ldapDecoder = new LdapDecoder();
    }

    public void decode(Object encoded) throws DecoderException {
        ByteBuffer buf = null;
        if (encoded instanceof ByteBuffer) {
            buf = (ByteBuffer)encoded;
        } else if (encoded instanceof byte[]) {
            buf = ByteBuffer.wrap((byte[])encoded);
        } else {
            throw new DecoderException("Expected either a byte[] or ByteBuffer argument but got a " + encoded.getClass());
        }
        if (log.isDebugEnabled()) {
            log.debug("Decoding the PDU : ");
            if (buf.hasArray()) {
                log.debug(StringUtils.dumpBytes((byte[])buf.array()));
            } else {
                byte[] array = new byte[buf.capacity()];
                int i = 0;
                while (buf.hasRemaining()) {
                    array[i++] = buf.get();
                }
                buf.flip();
                log.debug(StringUtils.dumpBytes((byte[])array));
            }
        }
        this.ldapDecoder.decode(buf, (IAsn1Container)this.ldapMessageContainer);
        if (this.ldapMessageContainer.getState() == 1024) {
            if (log.isDebugEnabled()) {
                log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
            }
            this.decoderCallback.decodeOccurred(null, (Object)this.ldapMessageContainer.getLdapMessage());
            this.ldapMessageContainer.clean();
        }
    }

    private void digest(InputStream in) throws ProviderException {
        byte[] buf = null;
        try {
            int amount = -1;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.ldapDecoder.decode(ByteBuffer.wrap(buf, 0, amount), (IAsn1Container)this.ldapMessageContainer);
            }
        }
        catch (Exception e) {
            log.error("Twix decoder failure : " + e.getMessage());
            ProviderException pe = new ProviderException(this.provider, "Twix decoder failure!");
            pe.addThrowable((Throwable)e);
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws ProviderException {
        Object pe2;
        if (lock == null) {
            this.digest(in);
            if (this.ldapMessageContainer.getState() == 1024) {
                if (log.isDebugEnabled()) {
                    log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
                }
                return this.ldapMessageContainer.getLdapMessage();
            }
            log.error("Twix decoder failure, PDU does not contain enough data");
            ProviderException pe2 = new ProviderException(this.provider, "Twix decoder failure!");
            pe2.addThrowable((Throwable)new DecoderException("The input stream does not contain a full PDU"));
            throw pe2;
        }
        try {
            pe2 = lock;
            synchronized (pe2) {
                this.digest(in);
                lock.notifyAll();
            }
        }
        catch (Exception e) {
            log.error("Twix decoder failure : " + e.getMessage());
            ProviderException pe3 = new ProviderException(this.provider, "Twix decoder failure!");
            pe3.addThrowable((Throwable)e);
            throw pe3;
        }
        if (this.ldapMessageContainer.getState() == 1024) {
            if (log.isDebugEnabled()) {
                log.debug("Decoded LdapMessage : " + (Object)((Object)this.ldapMessageContainer.getLdapMessage()));
            }
            return this.ldapMessageContainer.getLdapMessage();
        }
        log.error("Twix decoder failure : The input stream does not contain a full PDU");
        pe2 = new ProviderException(this.provider, "Twix decoder failure!");
        pe2.addThrowable((Throwable)new DecoderException("The input stream does not contain a full PDU"));
        throw pe2;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
    }

    public void setCallback(DecoderCallback cb) {
        this.decoderCallback = cb;
    }
}

