/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.EncoderMonitor;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.util.StringUtils;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.ProviderEncoder;
import org.apache.ldap.common.message.spi.ProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixEncoder
implements ProviderEncoder {
    private static Logger log = LoggerFactory.getLogger((Class)TwixEncoder.class);
    private final Provider provider;
    private EncoderCallback encodeCallback;

    public TwixEncoder(Provider provider) {
        this.provider = provider;
        this.encodeCallback = new OutputCallback();
    }

    public void encodeBlocking(Object lock, OutputStream out, Object obj) throws ProviderException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            this.encodeCallback.encodeOccurred(null, (Object)((LdapMessage)((Object)obj)).encode(null));
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj);
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj);
            throw pe;
        }
    }

    public ByteBuffer encodeBlocking(Object obj) throws ProviderException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            ByteBuffer pdu = ((LdapMessage)((Object)obj)).encode(null);
            if (log.isDebugEnabled()) {
                log.debug("Encoded PDU : " + StringUtils.dumpBytes((byte[])pdu.array()));
            }
            pdu.flip();
            return pdu;
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj);
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj);
            throw pe;
        }
    }

    public byte[] encodeToArray(Object obj) throws ProviderException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Encoding this LdapMessage : " + obj);
            }
            byte[] pdu = ((LdapMessage)((Object)obj)).encode(null).array();
            if (log.isDebugEnabled()) {
                log.debug("Encoded PDU : " + StringUtils.dumpBytes((byte[])pdu));
            }
            return pdu;
        }
        catch (EncoderException e) {
            log.error("Twix encoder failed to encode object: " + obj);
            ProviderException pe = new ProviderException(this.provider, "Twix encoder failed to encode object: " + obj);
            throw pe;
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void encode(Object obj) throws EncoderException {
        ByteBuffer encoded = this.encodeBlocking(obj);
        this.encodeCallback.encodeOccurred(null, (Object)encoded);
    }

    public void setCallback(EncoderCallback cb) {
        this.encodeCallback = cb;
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
    }

    class OutputCallback
    implements EncoderCallback {
        private WritableByteChannel channel = null;

        OutputCallback() {
        }

        public void encodeOccurred(StatefulEncoder encoder, Object encoded) {
            try {
                this.channel.write((ByteBuffer)encoded);
            }
            catch (IOException e) {
                ProviderException pe = new ProviderException(TwixEncoder.this.provider, "Twix encoder failed to write object ");
                throw pe;
            }
        }

        void attach(WritableByteChannel channel) {
            this.channel = channel;
        }

        void attach(OutputStream out) {
            this.channel = Channels.newChannel(out);
        }
    }
}

