/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.codec.primitives.LdapURL;
import org.apache.asn1new.ldap.codec.primitives.LdapURLEncodingException;
import org.apache.asn1new.ldap.pojo.AbandonRequest;
import org.apache.asn1new.ldap.pojo.AddRequest;
import org.apache.asn1new.ldap.pojo.AddResponse;
import org.apache.asn1new.ldap.pojo.AttributeValueAssertion;
import org.apache.asn1new.ldap.pojo.BindRequest;
import org.apache.asn1new.ldap.pojo.BindResponse;
import org.apache.asn1new.ldap.pojo.CompareRequest;
import org.apache.asn1new.ldap.pojo.CompareResponse;
import org.apache.asn1new.ldap.pojo.Control;
import org.apache.asn1new.ldap.pojo.DelRequest;
import org.apache.asn1new.ldap.pojo.DelResponse;
import org.apache.asn1new.ldap.pojo.ExtendedRequest;
import org.apache.asn1new.ldap.pojo.ExtendedResponse;
import org.apache.asn1new.ldap.pojo.LdapAuthentication;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.LdapResult;
import org.apache.asn1new.ldap.pojo.ModifyDNRequest;
import org.apache.asn1new.ldap.pojo.ModifyDNResponse;
import org.apache.asn1new.ldap.pojo.ModifyRequest;
import org.apache.asn1new.ldap.pojo.ModifyResponse;
import org.apache.asn1new.ldap.pojo.SaslCredentials;
import org.apache.asn1new.ldap.pojo.SearchRequest;
import org.apache.asn1new.ldap.pojo.SearchResultDone;
import org.apache.asn1new.ldap.pojo.SearchResultEntry;
import org.apache.asn1new.ldap.pojo.SearchResultReference;
import org.apache.asn1new.ldap.pojo.SimpleAuthentication;
import org.apache.asn1new.ldap.pojo.filters.AndFilter;
import org.apache.asn1new.ldap.pojo.filters.AttributeValueAssertionFilter;
import org.apache.asn1new.ldap.pojo.filters.ConnectorFilter;
import org.apache.asn1new.ldap.pojo.filters.ExtensibleMatchFilter;
import org.apache.asn1new.ldap.pojo.filters.Filter;
import org.apache.asn1new.ldap.pojo.filters.NotFilter;
import org.apache.asn1new.ldap.pojo.filters.OrFilter;
import org.apache.asn1new.ldap.pojo.filters.PresentFilter;
import org.apache.asn1new.ldap.pojo.filters.SubstringFilter;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ExtensibleNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.common.filter.SubstringNode;
import org.apache.ldap.common.message.AbandonRequestImpl;
import org.apache.ldap.common.message.AddRequestImpl;
import org.apache.ldap.common.message.AddResponseImpl;
import org.apache.ldap.common.message.BindRequestImpl;
import org.apache.ldap.common.message.BindResponseImpl;
import org.apache.ldap.common.message.CompareRequestImpl;
import org.apache.ldap.common.message.CompareResponseImpl;
import org.apache.ldap.common.message.ControlImpl;
import org.apache.ldap.common.message.DeleteRequestImpl;
import org.apache.ldap.common.message.DeleteResponseImpl;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.common.message.ExtendedRequestImpl;
import org.apache.ldap.common.message.ExtendedResponseImpl;
import org.apache.ldap.common.message.LdapResultImpl;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageTypeEnum;
import org.apache.ldap.common.message.ModifyDnRequestImpl;
import org.apache.ldap.common.message.ModifyDnResponseImpl;
import org.apache.ldap.common.message.ModifyRequestImpl;
import org.apache.ldap.common.message.ModifyResponseImpl;
import org.apache.ldap.common.message.Referral;
import org.apache.ldap.common.message.ReferralImpl;
import org.apache.ldap.common.message.ScopeEnum;
import org.apache.ldap.common.message.SearchRequestImpl;
import org.apache.ldap.common.message.SearchResponseDoneImpl;
import org.apache.ldap.common.message.SearchResponseEntryImpl;
import org.apache.ldap.common.message.SearchResponseReferenceImpl;
import org.apache.ldap.common.message.UnbindRequestImpl;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.TransformerSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwixTransformer
implements TransformerSpi {
    private static Logger log = LoggerFactory.getLogger((Class)TwixTransformer.class);
    private final Provider provider;

    public TwixTransformer(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    private Message transformAbandonRequest(LdapMessage twixMessage, int messageId) {
        AbandonRequestImpl snickersMessage = new AbandonRequestImpl(messageId);
        AbandonRequest abandonRequest = twixMessage.getAbandonRequest();
        snickersMessage.setAbandoned(abandonRequest.getAbandonedMessageId());
        return snickersMessage;
    }

    private Message transformAddRequest(LdapMessage twixMessage, int messageId) {
        AddRequestImpl snickersMessage = new AddRequestImpl(messageId);
        AddRequest addRequest = twixMessage.getAddRequest();
        snickersMessage.setName(addRequest.getEntry());
        snickersMessage.setEntry(addRequest.getAttributes());
        return snickersMessage;
    }

    private Message transformBindRequest(LdapMessage twixMessage, int messageId) {
        BindRequestImpl snickersMessage = new BindRequestImpl(messageId);
        BindRequest bindRequest = twixMessage.getBindRequest();
        snickersMessage.setVersion3(bindRequest.isLdapV3());
        snickersMessage.setName(bindRequest.getName());
        LdapAuthentication authentication = bindRequest.getAuthentication();
        if (authentication instanceof SimpleAuthentication) {
            snickersMessage.setSimple(true);
            snickersMessage.setCredentials(((SimpleAuthentication)authentication).getSimple().getValue());
        } else {
            snickersMessage.setSimple(false);
            snickersMessage.setCredentials(((SaslCredentials)authentication).getCredentials().getValue());
            snickersMessage.setSaslMechanism(((SaslCredentials)authentication).getMechanism());
        }
        return snickersMessage;
    }

    private Message transformCompareRequest(LdapMessage twixMessage, int messageId) {
        CompareRequestImpl snickersMessage = new CompareRequestImpl(messageId);
        CompareRequest compareRequest = twixMessage.getCompareRequest();
        snickersMessage.setName(compareRequest.getEntry());
        snickersMessage.setAttributeId(compareRequest.getAttributeDesc());
        snickersMessage.setAssertionValue(compareRequest.getAssertionValue().getValue());
        return snickersMessage;
    }

    private Message transformDelRequest(LdapMessage twixMessage, int messageId) {
        DeleteRequestImpl snickersMessage = new DeleteRequestImpl(messageId);
        DelRequest delRequest = twixMessage.getDelRequest();
        snickersMessage.setName(delRequest.getEntry());
        return snickersMessage;
    }

    private Message transformExtendedRequest(LdapMessage twixMessage, int messageId) {
        ExtendedRequestImpl snickersMessage = new ExtendedRequestImpl(messageId);
        ExtendedRequest extendedRequest = twixMessage.getExtendedRequest();
        snickersMessage.setOid(extendedRequest.getRequestName());
        snickersMessage.setPayload(extendedRequest.getRequestValue().getValue());
        return snickersMessage;
    }

    private Message transformModifyDNRequest(LdapMessage twixMessage, int messageId) {
        ModifyDnRequestImpl snickersMessage = new ModifyDnRequestImpl(messageId);
        ModifyDNRequest modifyDNRequest = twixMessage.getModifyDNRequest();
        snickersMessage.setName(modifyDNRequest.getEntry());
        snickersMessage.setNewRdn(modifyDNRequest.getNewRDN());
        snickersMessage.setDeleteOldRdn(modifyDNRequest.isDeleteOldRDN());
        snickersMessage.setNewSuperior(modifyDNRequest.getNewSuperior());
        return snickersMessage;
    }

    private Message transformModifyRequest(LdapMessage twixMessage, int messageId) {
        ModifyRequestImpl snickersMessage = new ModifyRequestImpl(messageId);
        ModifyRequest modifyRequest = twixMessage.getModifyRequest();
        snickersMessage.setName(modifyRequest.getObject());
        if (modifyRequest.getModifications() != null) {
            Iterator modifications = modifyRequest.getModifications().iterator();
            while (modifications.hasNext()) {
                snickersMessage.addModification((ModificationItem)modifications.next());
            }
        }
        return snickersMessage;
    }

    private ExprNode transformFilter(Filter twixFilter) {
        if (twixFilter != null) {
            if (twixFilter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (twixFilter instanceof AndFilter) {
                    branch = new BranchNode(10);
                } else if (twixFilter instanceof OrFilter) {
                    branch = new BranchNode(9);
                } else if (twixFilter instanceof NotFilter) {
                    branch = new BranchNode(11);
                }
                ArrayList filtersSet = ((ConnectorFilter)twixFilter).getFilterSet();
                if (filtersSet != null) {
                    Iterator filters = filtersSet.iterator();
                    while (filters.hasNext()) {
                        branch.addNode(this.transformFilter((Filter)((Object)filters.next())));
                    }
                }
                return branch;
            }
            PresenceNode branch = null;
            if (twixFilter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)twixFilter).getAttributeDescription().toString());
            } else if (twixFilter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)twixFilter).getAssertion();
                switch (((AttributeValueAssertionFilter)twixFilter).getFilterType()) {
                    case 0: {
                        branch = new SimpleNode(ava.getAttributeDesc().toString(), ava.getAssertionValue().toString(), 0);
                        break;
                    }
                    case 1: {
                        branch = new SimpleNode(ava.getAttributeDesc().toString(), ava.getAssertionValue().toString(), 3);
                        break;
                    }
                    case 2: {
                        branch = new SimpleNode(ava.getAttributeDesc().toString(), ava.getAssertionValue().toString(), 4);
                        break;
                    }
                    case 3: {
                        branch = new SimpleNode(ava.getAttributeDesc().toString(), ava.getAssertionValue().toString(), 5);
                    }
                }
            } else if (twixFilter instanceof SubstringFilter) {
                SubstringFilter filter = (SubstringFilter)twixFilter;
                String initialString = null;
                String finalString = null;
                ArrayList anyString = null;
                if (filter.getInitialSubstrings() != null) {
                    initialString = filter.getInitialSubstrings().toString();
                }
                if (filter.getFinalSubstrings() != null) {
                    finalString = filter.getFinalSubstrings().toString();
                }
                if (filter.getAnySubstrings() != null) {
                    Iterator iter = filter.getAnySubstrings().iterator();
                    anyString = new ArrayList();
                    while (iter.hasNext()) {
                        anyString.add(iter.next());
                    }
                }
                branch = new SubstringNode(anyString, filter.getType().toString(), initialString, finalString);
            } else if (twixFilter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter filter = (ExtensibleMatchFilter)twixFilter;
                String attribute = null;
                String value = null;
                String matchingRule = null;
                if (filter.getType() != null) {
                    attribute = filter.getType().toString();
                }
                if (filter.getMatchValue() != null) {
                    value = filter.getMatchValue().toString();
                }
                if (filter.getMatchingRule() != null) {
                    matchingRule = filter.getMatchingRule().toString();
                }
                branch = new ExtensibleNode(attribute, value, matchingRule, filter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    private Message transformSearchRequest(LdapMessage twixMessage, int messageId) {
        NamingEnumeration<? extends Attribute> attributes;
        SearchRequestImpl snickersMessage = new SearchRequestImpl(messageId);
        SearchRequest searchRequest = twixMessage.getSearchRequest();
        snickersMessage.setBase(searchRequest.getBaseObject());
        switch (searchRequest.getScope()) {
            case 0: {
                snickersMessage.setScope(ScopeEnum.BASEOBJECT);
                break;
            }
            case 1: {
                snickersMessage.setScope(ScopeEnum.SINGLELEVEL);
                break;
            }
            case 2: {
                snickersMessage.setScope(ScopeEnum.WHOLESUBTREE);
            }
        }
        switch (searchRequest.getDerefAliases()) {
            case 3: {
                snickersMessage.setDerefAliases(DerefAliasesEnum.DEREFALWAYS);
                break;
            }
            case 2: {
                snickersMessage.setDerefAliases(DerefAliasesEnum.DEREFFINDINGBASEOBJ);
                break;
            }
            case 1: {
                snickersMessage.setDerefAliases(DerefAliasesEnum.DEREFINSEARCHING);
                break;
            }
            case 0: {
                snickersMessage.setDerefAliases(DerefAliasesEnum.NEVERDEREFALIASES);
            }
        }
        snickersMessage.setSizeLimit(searchRequest.getSizeLimit());
        snickersMessage.setTimeLimit(searchRequest.getTimeLimit());
        snickersMessage.setTypesOnly(searchRequest.isTypesOnly());
        Filter twixFilter = searchRequest.getFilter();
        snickersMessage.setFilter(this.transformFilter(twixFilter));
        if (searchRequest.getAttributes() != null && (attributes = searchRequest.getAttributes().getAll()) != null) {
            while (attributes.hasMoreElements()) {
                BasicAttribute attribute = (BasicAttribute)attributes.nextElement();
                if (attribute == null) continue;
                snickersMessage.addAttribute(attribute.getID());
            }
        }
        return snickersMessage;
    }

    private Message transformUnBindRequest(LdapMessage twixMessage, int messageId) {
        return new UnbindRequestImpl(messageId);
    }

    public Message transform(Object obj) {
        LdapMessage twixMessage = (LdapMessage)((Object)obj);
        int messageId = twixMessage.getMessageId();
        if (log.isDebugEnabled()) {
            log.debug("Transforming LdapMessage <" + messageId + ", " + twixMessage.getMessageTypeName() + "> from Twix to Snickers.");
        }
        Message snickersMessage = null;
        int messageType = twixMessage.getMessageType();
        switch (messageType) {
            case 3: {
                snickersMessage = this.transformBindRequest(twixMessage, messageId);
                break;
            }
            case 19: {
                snickersMessage = this.transformUnBindRequest(twixMessage, messageId);
                break;
            }
            case 15: {
                snickersMessage = this.transformSearchRequest(twixMessage, messageId);
                break;
            }
            case 13: {
                snickersMessage = this.transformModifyRequest(twixMessage, messageId);
                break;
            }
            case 1: {
                snickersMessage = this.transformAddRequest(twixMessage, messageId);
                break;
            }
            case 7: {
                snickersMessage = this.transformDelRequest(twixMessage, messageId);
                break;
            }
            case 11: {
                snickersMessage = this.transformModifyDNRequest(twixMessage, messageId);
                break;
            }
            case 5: {
                snickersMessage = this.transformCompareRequest(twixMessage, messageId);
                break;
            }
            case 0: {
                snickersMessage = this.transformAbandonRequest(twixMessage, messageId);
                break;
            }
            case 9: {
                snickersMessage = this.transformExtendedRequest(twixMessage, messageId);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            default: {
                throw new IllegalStateException("shouldn't happen - if it does then we have issues");
            }
        }
        ArrayList twixControls = twixMessage.getControls();
        if (twixControls != null) {
            Iterator controls = twixControls.iterator();
            while (controls.hasNext()) {
                Control twixControl = (Control)((Object)controls.next());
                ControlImpl snickersControl = new ControlImpl((Lockable)snickersMessage){
                    public static final long serialVersionUID = 1L;

                    public byte[] getEncodedValue() {
                        return null;
                    }
                };
                snickersControl.setCritical(twixControl.getCriticality());
                snickersControl.setType(twixControl.getControlType());
                snickersControl.setValue(twixControl.getControlValue());
                snickersMessage.add((org.apache.ldap.common.message.Control)snickersControl);
            }
        }
        return snickersMessage;
    }

    private LdapResult transformLdapResult(LdapResultImpl snickersLdapResult) {
        LdapResult twixLdapResult = new LdapResult();
        twixLdapResult.setResultCode(snickersLdapResult.getResultCode().getValue());
        try {
            String errorMessage = snickersLdapResult.getErrorMessage();
            if (errorMessage == null || errorMessage.length() == 0) {
                twixLdapResult.setErrorMessage(LdapString.EMPTY_STRING);
            } else {
                twixLdapResult.setErrorMessage(new LdapString(snickersLdapResult.getErrorMessage().getBytes()));
            }
        }
        catch (LdapStringEncodingException lsee) {
            log.warn("The error message " + snickersLdapResult.getErrorMessage() + " is invalid : " + lsee.getMessage());
            twixLdapResult.setErrorMessage(LdapString.EMPTY_STRING);
        }
        try {
            String matchedDn = snickersLdapResult.getMatchedDn();
            if (matchedDn == null || matchedDn.length() == 0) {
                twixLdapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
            } else {
                twixLdapResult.setMatchedDN(new LdapDN(snickersLdapResult.getMatchedDn()));
            }
        }
        catch (InvalidNameException ine) {
            log.warn("The DN  " + snickersLdapResult.getMatchedDn() + " is invalid : " + ine.getMessage());
            twixLdapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
        }
        ReferralImpl snisckersReferrals = (ReferralImpl)snickersLdapResult.getReferral();
        if (snisckersReferrals != null) {
            Iterator referrals = snisckersReferrals.getLdapUrls().iterator();
            while (referrals.hasNext()) {
                String referral = (String)referrals.next();
                try {
                    LdapURL ldapUrl = new LdapURL(referral.getBytes());
                    twixLdapResult.addReferral(ldapUrl);
                }
                catch (LdapURLEncodingException lude) {
                    log.warn("The referral " + referral + " is invalid : " + lude.getMessage());
                    twixLdapResult.addReferral(LdapURL.EMPTY_URL);
                }
            }
        }
        return twixLdapResult;
    }

    private void transformAddResponse(LdapMessage twixMessage, Message snickersMessage) {
        AddResponseImpl snickersAddResponse = (AddResponseImpl)snickersMessage;
        AddResponse addResponse = new AddResponse();
        addResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersAddResponse.getLdapResult()));
        twixMessage.setProtocolOP(addResponse);
    }

    private void transformBindResponse(LdapMessage twixMessage, Message snickersMessage) {
        BindResponseImpl snickersBindResponse = (BindResponseImpl)snickersMessage;
        BindResponse bindResponse = new BindResponse();
        byte[] serverSaslCreds = snickersBindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            bindResponse.setServerSaslCreds(new OctetString(serverSaslCreds));
        }
        bindResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersBindResponse.getLdapResult()));
        twixMessage.setProtocolOP(bindResponse);
    }

    private void transformCompareResponse(LdapMessage twixMessage, Message snickersMessage) {
        CompareResponseImpl snickersCompareResponse = (CompareResponseImpl)snickersMessage;
        CompareResponse compareResponse = new CompareResponse();
        compareResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersCompareResponse.getLdapResult()));
        twixMessage.setProtocolOP(compareResponse);
    }

    private void transformDelResponse(LdapMessage twixMessage, Message snickersMessage) {
        DeleteResponseImpl snickersDelResponse = (DeleteResponseImpl)snickersMessage;
        DelResponse delResponse = new DelResponse();
        delResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersDelResponse.getLdapResult()));
        twixMessage.setProtocolOP(delResponse);
    }

    private void transformExtendedResponse(LdapMessage twixMessage, Message snickersMessage) {
        ExtendedResponseImpl snickersExtendedResponse = (ExtendedResponseImpl)snickersMessage;
        ExtendedResponse extendedResponse = new ExtendedResponse();
        try {
            extendedResponse.setResponseName(new OID(snickersExtendedResponse.getResponseName()));
        }
        catch (DecoderException de) {
            log.warn("The OID " + snickersExtendedResponse.getResponseName() + " is invalid : " + de.getMessage());
            extendedResponse.setResponseName(null);
        }
        extendedResponse.setResponse(new OctetString(snickersExtendedResponse.getResponse()));
        extendedResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersExtendedResponse.getLdapResult()));
        twixMessage.setProtocolOP(extendedResponse);
    }

    private void transformModifyResponse(LdapMessage twixMessage, Message snickersMessage) {
        ModifyResponseImpl snickersModifyResponse = (ModifyResponseImpl)snickersMessage;
        ModifyResponse modifyResponse = new ModifyResponse();
        modifyResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersModifyResponse.getLdapResult()));
        twixMessage.setProtocolOP(modifyResponse);
    }

    private void transformModifyDNResponse(LdapMessage twixMessage, Message snickersMessage) {
        ModifyDnResponseImpl snickersModifyDNResponse = (ModifyDnResponseImpl)snickersMessage;
        ModifyDNResponse modifyDNResponse = new ModifyDNResponse();
        modifyDNResponse.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersModifyDNResponse.getLdapResult()));
        twixMessage.setProtocolOP(modifyDNResponse);
    }

    private void transformSearchResultDone(LdapMessage twixMessage, Message snickersMessage) {
        SearchResponseDoneImpl snickersSearchResponseDone = (SearchResponseDoneImpl)snickersMessage;
        SearchResultDone searchResultDone = new SearchResultDone();
        searchResultDone.setLdapResult(this.transformLdapResult((LdapResultImpl)snickersSearchResponseDone.getLdapResult()));
        twixMessage.setProtocolOP(searchResultDone);
    }

    private void transformSearchResultEntry(LdapMessage twixMessage, Message snickersMessage) {
        SearchResponseEntryImpl snickersSearchResultResponse = (SearchResponseEntryImpl)snickersMessage;
        SearchResultEntry searchResultEntry = new SearchResultEntry();
        try {
            searchResultEntry.setObjectName(new LdapDN(snickersSearchResultResponse.getObjectName().getBytes()));
        }
        catch (InvalidNameException ine) {
            log.warn("The DN " + snickersSearchResultResponse.getObjectName() + " is invalid : " + ine.getMessage());
            searchResultEntry.setObjectName(LdapDN.EMPTY_LDAPDN);
        }
        searchResultEntry.setPartialAttributeList(snickersSearchResultResponse.getAttributes());
        twixMessage.setProtocolOP(searchResultEntry);
    }

    private void transformSearchResultReference(LdapMessage twixMessage, Message snickersMessage) {
        Collection urls;
        SearchResponseReferenceImpl snickersSearchResponseReference = (SearchResponseReferenceImpl)snickersMessage;
        SearchResultReference searchResultReference = new SearchResultReference();
        Referral referrals = snickersSearchResponseReference.getReferral();
        if (referrals != null && (urls = referrals.getLdapUrls()) != null) {
            Iterator url = urls.iterator();
            while (url.hasNext()) {
                String urlValue = (String)url.next();
                try {
                    searchResultReference.addSearchResultReference(new LdapURL(urlValue));
                }
                catch (LdapURLEncodingException luee) {
                    log.warn("The LdapURL " + urlValue + " is incorrect : " + luee.getMessage());
                }
            }
        }
        twixMessage.setProtocolOP(searchResultReference);
    }

    public Object transform(Message msg) {
        if (log.isDebugEnabled()) {
            log.debug("Transforming message type " + msg.getType());
        }
        LdapMessage twixMessage = new LdapMessage();
        twixMessage.setMessageId(msg.getMessageId());
        if (msg.getType() == MessageTypeEnum.SEARCHRESENTRY) {
            this.transformSearchResultEntry(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.SEARCHRESDONE) {
            this.transformSearchResultDone(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.SEARCHRESREF) {
            this.transformSearchResultReference(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.BINDRESPONSE) {
            this.transformBindResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.ADDRESPONSE) {
            this.transformAddResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.COMPARERESPONSE) {
            this.transformCompareResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.DELRESPONSE) {
            this.transformDelResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.MODIFYRESPONSE) {
            this.transformModifyResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.MODDNRESPONSE) {
            this.transformModifyDNResponse(twixMessage, msg);
        } else if (msg.getType() == MessageTypeEnum.EXTENDEDRESP) {
            this.transformExtendedResponse(twixMessage, msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("Transformed message : " + (Object)((Object)twixMessage));
        }
        return twixMessage;
    }
}

