/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.AbandonRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.util.IntegerDecoder;
import org.apache.asn1new.util.IntegerDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AbandonRequestGrammar.class);
    private static IGrammar instance = new AbandonRequestGrammar();

    private AbandonRequestGrammar() {
        this.name = AbandonRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ABANDON_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_TAG][80] = new GrammarTransition(LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_TAG, LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE, null);
        this.transitions[LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE][80] = new GrammarTransition(LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE, -1, new GrammarAction("Store MessageId"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int abandonnedMessageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    AbandonRequest abandonRequest = new AbandonRequest();
                    abandonRequest.setAbandonedMessageId(abandonnedMessageId);
                    ldapMessage.setProtocolOP(abandonRequest);
                    if (log.isDebugEnabled()) {
                        log.debug("AbandonMessage Id has been decoded : " + abandonnedMessageId);
                    }
                    return;
                }
                catch (IntegerDecoderException ide) {
                    log.error("The Abandonned Message Id " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + ide.getMessage() + ". The message ID must be between (0 .. 2 147 483 647)");
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

