/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.AddRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AddRequestGrammar.class);
    private static IGrammar instance = new AddRequestGrammar();

    private AddRequestGrammar() {
        this.name = AddRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ADD_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.ADD_REQUEST_TAG][104] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_TAG, LdapStatesEnum.ADD_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_VALUE][104] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_VALUE, LdapStatesEnum.ADD_REQUEST_ENTRY_TAG, new GrammarAction("Init addRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new AddRequest());
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ENTRY_TAG, LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ENTRY_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TAG, new GrammarAction("Store add request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The DN can't be null");
                }
                try {
                    addRequest.setEntry(new LdapDN(tlv.getValue().getData()));
                }
                catch (InvalidNameException ine) {
                    log.error("The DN is invalid : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + " : " + ine.getMessage());
                    throw new DecoderException("Incorrect DN given : " + ine.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Adding an entry with DN : " + addRequest.getEntry());
                }
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TAG][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALUE][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG, new GrammarAction("Init attributes array list"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                addRequest.initAttributes();
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_OR_ATTRIBUTE_OR_END][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_OR_ATTRIBUTE_OR_END, LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE][48] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTE_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_TYPE_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_TAG, new GrammarAction("Store attribute type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AddRequest addRequest = ldapMessage.getAddRequest();
                LdapString type = null;
                if (tlv.getLength().getLength() == 0) {
                    log.error("Null types are not allowed");
                    throw new DecoderException("The type can't be null");
                }
                try {
                    type = new LdapString(tlv.getValue().getData());
                    addRequest.addAttributeType(type);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The type is invalid : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + " : " + lsee.getMessage());
                    throw new DecoderException("Invalid attribute type : " + lsee.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Adding type " + type);
                }
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VALS_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_TAG, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_TAG][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_TAG, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_OR_ATTRIBUTE_OR_END][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_OR_ATTRIBUTE_OR_END, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_VALUE][4] = new GrammarTransition(LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_VALUE, LdapStatesEnum.ADD_REQUEST_ATTRIBUTES_VAL_OR_ATTRIBUTE_OR_END, new GrammarAction("Store attribute value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddRequest addRequest = ldapMessage.getAddRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                OctetString value = OctetString.EMPTY_STRING;
                if (tlv.getLength().getLength() == 0) {
                    addRequest.addAttributeValue(value);
                } else {
                    value = new OctetString(tlv.getValue().getData());
                    addRequest.addAttributeValue(value);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Adding value " + value);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

