/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.AddResponse;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AddResponseGrammar.class);
    private static IGrammar instance = new AddResponseGrammar();

    private AddResponseGrammar() {
        this.name = AddResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ADD_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.ADD_RESPONSE_TAG][105] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_TAG, LdapStatesEnum.ADD_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_RESPONSE_VALUE][105] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_VALUE, LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT, new GrammarAction("Init AddResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                AddResponse addResponse = new AddResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int expectedLength = tlv.getLength().getLength();
                addResponse.setExpectedLength(expectedLength);
                addResponse.setCurrentLength(0);
                addResponse.setParent(ldapMessage);
                ldapMessage.setProtocolOP(addResponse);
                if (log.isDebugEnabled()) {
                    log.debug("Add Response");
                }
            }
        });
        this.transitions[LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT, 512, null);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

