/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.BindRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SaslCredentials;
import org.apache.asn1new.ldap.pojo.SimpleAuthentication;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.IntegerDecoder;
import org.apache.asn1new.util.IntegerDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)BindRequestGrammar.class);
    private static IGrammar instance = new BindRequestGrammar();

    public static IGrammar getInstance() {
        return instance;
    }

    private BindRequestGrammar() {
        this.name = BindRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_BIND_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.BIND_REQUEST_TAG][96] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_TAG, LdapStatesEnum.BIND_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_VALUE][96] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VALUE, LdapStatesEnum.BIND_REQUEST_VERSION_TAG, new GrammarAction("Init BindRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new BindRequest());
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_VERSION_TAG][2] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VERSION_TAG, LdapStatesEnum.BIND_REQUEST_VERSION_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_VERSION_VALUE][2] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_VERSION_VALUE, LdapStatesEnum.BIND_REQUEST_NAME_TAG, new GrammarAction("Store version"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int version = IntegerDecoder.parse((Value)value, (int)1, (int)127);
                    if (version != 3) {
                        log.error("The version " + version + " is invalid : it must be 3");
                        throw new DecoderException("Ldap Version " + version + " is not supported");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Ldap version " + version);
                    }
                    bindRequestMessage.setVersion(version);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The version " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + ide.getMessage() + ". The version must be between (0 .. 127)");
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_NAME_TAG][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_NAME_TAG, LdapStatesEnum.BIND_REQUEST_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_NAME_VALUE][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_NAME_VALUE, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, new GrammarAction("Store Bind Name value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    bindRequestMessage.setName(LdapDN.EMPTY_LDAPDN);
                } else {
                    try {
                        bindRequestMessage.setName(new LdapDN(tlv.getValue().getData()));
                    }
                    catch (InvalidNameException ine) {
                        log.error("Incorrect DN given : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + " : " + ine.getMessage());
                        throw new DecoderException("Incorrect DN given : " + ine.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(" The Bind name is " + bindRequestMessage.getName());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG][128] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE][128] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_SIMPLE_VALUE, -1, new GrammarAction("Store Bind Simple Authentication value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SimpleAuthentication authentication = null;
                authentication = new SimpleAuthentication();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (tlv.getLength().getLength() == 0) {
                    authentication.setSimple(OctetString.EMPTY_STRING);
                } else {
                    authentication.setSimple(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("The simple authentication is : " + authentication.getSimple());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG][131] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CHOICE_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE][131] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_MECHANISM_VALUE, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG, new GrammarAction("Create Bind sasl Authentication Object"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials authentication = new SaslCredentials();
                authentication.setParent(bindRequestMessage);
                bindRequestMessage.setAuthentication(authentication);
                if (tlv.getLength().getLength() == 0) {
                    authentication.setMechanism(LdapString.EMPTY_STRING);
                } else {
                    try {
                        authentication.setMechanism(new LdapString(tlv.getValue().getData()));
                    }
                    catch (LdapStringEncodingException lsee) {
                        log.error("Invalid mechanism : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + " : " + lsee.getMessage());
                        throw new DecoderException(lsee.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("The mechanism is : " + authentication.getMechanism());
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_TAG, LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE][4] = new GrammarTransition(LdapStatesEnum.BIND_REQUEST_AUTHENTICATION_CREDENTIALS_VALUE, -1, new GrammarAction("Store Bind sasl Authentication credentials value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindRequest bindRequestMessage = ldapMessageContainer.getLdapMessage().getBindRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SaslCredentials credentials = bindRequestMessage.getSaslAuthentication();
                if (tlv.getLength().getLength() == 0) {
                    credentials.setCredentials(OctetString.EMPTY_STRING);
                } else {
                    credentials.setCredentials(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("The credentials are : " + credentials.getCredentials());
                }
            }
        });
    }
}

