/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.BindResponse;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)BindResponseGrammar.class);
    private static IGrammar instance = new BindResponseGrammar();

    private BindResponseGrammar() {
        this.name = BindResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_BIND_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.BIND_RESPONSE_TAG][97] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_TAG, LdapStatesEnum.BIND_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_VALUE][97] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_VALUE, LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, new GrammarAction("Init BindReponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                BindResponse bindResponse = new BindResponse();
                bindResponse.setParent(ldapMessage);
                ldapMessage.setProtocolOP(bindResponse);
            }
        });
        this.transitions[LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, 512, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_LDAP_RESULT, LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_TAG][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_TAG, LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, null);
        this.transitions[LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE][135] = new GrammarTransition(LdapStatesEnum.BIND_RESPONSE_SERVER_SASL_CREDS_VALUE, -1, new GrammarAction("Store server sasl credentials value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                BindResponse bindResponseMessage = ldapMessageContainer.getLdapMessage().getBindResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    bindResponseMessage.setServerSaslCreds(OctetString.EMPTY_STRING);
                } else {
                    bindResponseMessage.setServerSaslCreds(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("The SASL credentials value is : " + bindResponseMessage.getServerSaslCreds().toString());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

