/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.CompareRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)CompareRequestGrammar.class);
    private static IGrammar instance = new CompareRequestGrammar();

    private CompareRequestGrammar() {
        this.name = CompareRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_COMPARE_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_TAG][110] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_TAG, LdapStatesEnum.COMPARE_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_VALUE][110] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_VALUE, LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG, new GrammarAction("Init Compare Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new CompareRequest());
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ENTRY_TAG, LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ENTRY_VALUE, LdapStatesEnum.COMPARE_REQUEST_AVA_TAG, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    compareRequest.setEntry(entry);
                }
                catch (InvalidNameException ine) {
                    log.error("The DN to compare  (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Comparing DN " + entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_AVA_TAG][48] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_AVA_TAG, LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE][48] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_AVA_VALUE, LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_TAG, LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ATTRIBUTE_DESC_VALUE, LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG, new GrammarAction("Store attribute desc"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The attribute description must not be null");
                }
                try {
                    compareRequest.setAttributeDesc(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The attribute description (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid attribute description " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Comparing attribute description " + compareRequest.getAttributeDesc());
                }
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_TAG, LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.COMPARE_REQUEST_ASSERTION_VALUE_VALUE, -1, new GrammarAction("Store assertion value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                CompareRequest compareRequest = ldapMessage.getCompareRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    compareRequest.setAssertionValue(OctetString.EMPTY_STRING);
                } else {
                    compareRequest.setAssertionValue(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Comparing attribute value " + compareRequest.getAssertionValue());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

