/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.CompareResponse;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)CompareResponseGrammar.class);
    private static IGrammar instance = new CompareResponseGrammar();

    private CompareResponseGrammar() {
        this.name = CompareResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_COMPARE_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_TAG][111] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_TAG, LdapStatesEnum.COMPARE_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_VALUE][111] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_VALUE, LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT, new GrammarAction("Init CompareResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new CompareResponse());
                if (log.isDebugEnabled()) {
                    log.debug("Compare response ");
                }
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.COMPARE_RESPONSE_LDAP_RESULT, 512, null);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

