/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.pojo.DelRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)DelRequestGrammar.class);
    private static IGrammar instance = new DelRequestGrammar();

    private DelRequestGrammar() {
        this.name = DelRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_DEL_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.DEL_REQUEST_TAG][74] = new GrammarTransition(LdapStatesEnum.DEL_REQUEST_TAG, LdapStatesEnum.DEL_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.DEL_REQUEST_VALUE][74] = new GrammarTransition(LdapStatesEnum.DEL_REQUEST_VALUE, -1, new GrammarAction("Init del Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                DelRequest delRequest = new DelRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must not be null");
                }
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    delRequest.setEntry(entry);
                }
                catch (InvalidNameException ine) {
                    log.error("The DN to delete  (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                }
                ldapMessage.setProtocolOP(delRequest);
                if (log.isDebugEnabled()) {
                    log.debug("Deleting DN " + entry);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

