/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.ExtendedRequest;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ExtendedRequestGrammar.class);
    private static IGrammar instance = new ExtendedRequestGrammar();

    private ExtendedRequestGrammar() {
        this.name = ExtendedRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_EXTENDED_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_TAG][119] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_TAG, LdapStatesEnum.EXTENDED_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE][119] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE, LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG, new GrammarAction("Init Extended Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedRequest());
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG][128] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_NAME_TAG, LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE][128] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_NAME_VALUE, LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG, new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                extendedRequest.setRequestName(new OID(tlv.getValue().getData()));
                if (log.isDebugEnabled()) {
                    log.debug("OID read : " + extendedRequest.getRequestName());
                }
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG][129] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE_TAG, LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE][129] = new GrammarTransition(LdapStatesEnum.EXTENDED_REQUEST_VALUE_VALUE, -1, new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedRequest extendedRequest = ldapMessage.getExtendedRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    extendedRequest.setRequestValue(OctetString.EMPTY_STRING);
                } else {
                    extendedRequest.setRequestValue(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Extended value : " + extendedRequest.getRequestValue());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

