/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.ExtendedResponse;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ExtendedResponseGrammar.class);
    private static IGrammar instance = new ExtendedResponseGrammar();

    private ExtendedResponseGrammar() {
        this.name = ExtendedResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_EXTENDED_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_TAG][120] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_TAG, LdapStatesEnum.EXTENDED_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_VALUE][120] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_VALUE, LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, new GrammarAction("Init Extended Reponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ExtendedResponse());
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, 512, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT][138] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_LDAP_RESULT, LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE][138] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_NAME_VALUE, LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG, new GrammarAction("Store name"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedResponse extendedResponse = ldapMessage.getExtendedResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                extendedResponse.setResponseName(new OID(tlv.getValue().getData()));
                if (log.isDebugEnabled()) {
                    log.debug("OID read : " + extendedResponse.getResponseName());
                }
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG][139] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_TAG, LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE][139] = new GrammarTransition(LdapStatesEnum.EXTENDED_RESPONSE_RESPONSE_VALUE, -1, new GrammarAction("Store response"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ExtendedResponse extendedResponse = ldapMessage.getExtendedResponse();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    extendedResponse.setResponse(OctetString.EMPTY_STRING);
                } else {
                    extendedResponse.setResponse(new OctetString(tlv.getValue().getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Extended value : " + extendedResponse.getResponse());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

