/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.AttributeValueAssertion;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SearchRequest;
import org.apache.asn1new.ldap.pojo.filters.AndFilter;
import org.apache.asn1new.ldap.pojo.filters.AttributeValueAssertionFilter;
import org.apache.asn1new.ldap.pojo.filters.ConnectorFilter;
import org.apache.asn1new.ldap.pojo.filters.ExtensibleMatchFilter;
import org.apache.asn1new.ldap.pojo.filters.Filter;
import org.apache.asn1new.ldap.pojo.filters.NotFilter;
import org.apache.asn1new.ldap.pojo.filters.OrFilter;
import org.apache.asn1new.ldap.pojo.filters.PresentFilter;
import org.apache.asn1new.ldap.pojo.filters.SubstringFilter;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.BooleanDecoder;
import org.apache.asn1new.util.BooleanDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)FilterGrammar.class);
    private static IGrammar instance = new FilterGrammar();

    private FilterGrammar() {
        this.name = FilterGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_FILTER_STATE][256];
        this.transitions[LdapStatesEnum.FILTER_TAG][160] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_AND_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][161] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_OR_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][162] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_NOT_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][163] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][164] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][165] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][166] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][135] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_PRESENT_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][168] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_APPROX_MATCH_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_TAG][169] = new GrammarTransition(LdapStatesEnum.FILTER_TAG, LdapStatesEnum.FILTER_EXTENSIBLE_MATCH_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_AND_VALUE][160] = new GrammarTransition(LdapStatesEnum.FILTER_AND_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init And Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                AndFilter andFilter = new AndFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(andFilter);
                    andFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(andFilter);
                    andFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(andFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_OR_VALUE][161] = new GrammarTransition(LdapStatesEnum.FILTER_OR_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init Or Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                OrFilter orFilter = new OrFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(orFilter);
                    orFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(orFilter);
                    orFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(orFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_NOT_VALUE][162] = new GrammarTransition(LdapStatesEnum.FILTER_NOT_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init Not Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                NotFilter notFilter = new NotFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(notFilter);
                    notFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(notFilter);
                    notFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(notFilter);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE][163] = new GrammarTransition(LdapStatesEnum.FILTER_EQUALITY_MATCH_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Equality Match Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.compareFilterAction(container, 0);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE][165] = new GrammarTransition(LdapStatesEnum.FILTER_GREATER_OR_EQUAL_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Greater Or Equal Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.compareFilterAction(container, 1);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE][166] = new GrammarTransition(LdapStatesEnum.FILTER_LESS_OR_EQUAL_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init Less Or Equal Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.compareFilterAction(container, 2);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_APPROX_MATCH_VALUE][168] = new GrammarTransition(LdapStatesEnum.FILTER_APPROX_MATCH_VALUE, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, new GrammarAction("Init ApproxMatch Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                FilterGrammar.this.compareFilterAction(container, 3);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ATTRIBUTE_DESC_TAG, LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE, LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, new GrammarAction("Init attributeDesc Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AttributeValueAssertion assertion = new AttributeValueAssertion();
                try {
                    assertion.setAttributeDesc(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The assertion description (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid assertion description " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                AttributeValueAssertionFilter currentFilter = (AttributeValueAssertionFilter)searchRequest.getCurrentFilter();
                currentFilter.setAssertion(assertion);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init AssertionValue Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                OctetString assertionValue = OctetString.EMPTY_STRING;
                if (tlv.getLength().getLength() != 0) {
                    assertionValue = new OctetString(tlv.getValue().getData());
                }
                AttributeValueAssertionFilter currentFilter = (AttributeValueAssertionFilter)searchRequest.getCurrentFilter();
                AttributeValueAssertion assertion = currentFilter.getAssertion();
                assertion.setAssertionValue(assertionValue);
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_ATTRIBUTE_DESC_VALUE, LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, new GrammarAction("Init attributeDesc Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                AttributeValueAssertion assertion = new AttributeValueAssertion();
                try {
                    assertion.setAttributeDesc(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The assertion value (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid assertion value " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                AttributeValueAssertionFilter currentFilter = (AttributeValueAssertionFilter)searchRequest.getCurrentFilter();
                currentFilter.setAssertion(assertion);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_ASSERTION_VALUE_TAG, LdapStatesEnum.FILTER_ASSERTION_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_PRESENT_VALUE][135] = new GrammarTransition(LdapStatesEnum.FILTER_PRESENT_VALUE, LdapStatesEnum.FILTER_TAG, new GrammarAction("Init present filter Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                PresentFilter presentFilter = new PresentFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(presentFilter);
                    presentFilter.setParent(currentFilter);
                } else {
                    presentFilter.setParent(searchRequest);
                    searchRequest.setFilter(presentFilter);
                }
                try {
                    presentFilter.setAttributeDescription(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("Present filter attribute description (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid present filter attribute description " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_VALUE][164] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_VALUE, LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_TAG, new GrammarAction("Init Substring Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = new SubstringFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(substringFilter);
                    substringFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(substringFilter);
                    substringFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(substringFilter);
                int expectedLength = tlv.getLength().getLength();
                substringFilter.setExpectedLength(expectedLength);
                substringFilter.setCurrentLength(0);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_TYPE_VALUE, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_TAG, new GrammarAction("Store substring filter Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getCurrentFilter();
                try {
                    substringFilter.setType(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The substring filter type (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid substring filter type " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_TAG][48] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_VALUE][48] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_VALUE, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][128] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_INITIAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_INITIAL_VALUE][128] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_INITIAL_VALUE, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG, new GrammarAction("Store substring filter initial Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getCurrentFilter();
                try {
                    substringFilter.setInitialSubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The substring filter initial (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid substring filter initial " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][129] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG][129] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_VALUE][129] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_VALUE, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG, new GrammarAction("Store substring filter any Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getCurrentFilter();
                try {
                    substringFilter.addAnySubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The substring any filter (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid substring any filter " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG][130] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_FINAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][130] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_FINAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG][130] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_ANY_OR_FINAL_TAG, LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_FINAL_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_FINAL_VALUE][130] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_FINAL_VALUE, -1, new GrammarAction("Store substring filter final Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getCurrentFilter();
                try {
                    substringFilter.setFinalSubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The substring final filter (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid substring final filter " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][160] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][161] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][162] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][163] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][164] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][165] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][166] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][135] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][168] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][169] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG][48] = new GrammarTransition(LdapStatesEnum.FILTER_SUBSTRINGS_SUBSTRINGS_CHOICE_TAG, LdapStatesEnum.FILTER_TAG, new GrammarAction("Bad tag exception"){

            public void action(IAsn1Container container) throws DecoderException {
                throw new DecoderException("At least an 'initial', 'any' or 'final' value must be found");
            }
        });
        this.transitions[LdapStatesEnum.FILTER_EXTENSIBLE_MATCH_VALUE][169] = new GrammarTransition(LdapStatesEnum.FILTER_EXTENSIBLE_MATCH_VALUE, LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_TAG, new GrammarAction("Init extensible match Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter();
                Filter currentFilter = searchRequest.getCurrentFilter();
                if (currentFilter != null) {
                    ((ConnectorFilter)currentFilter).addFilter(extensibleMatchFilter);
                    extensibleMatchFilter.setParent(currentFilter);
                } else {
                    searchRequest.setFilter(extensibleMatchFilter);
                    extensibleMatchFilter.setParent(searchRequest);
                }
                searchRequest.setCurrentFilter(extensibleMatchFilter);
                FilterGrammar.this.unstackFilters(container);
            }
        });
        this.transitions[LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_TAG][48] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_TAG, LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_VALUE][48] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_ASSERTION_VALUE, LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG][129] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG, LdapStatesEnum.FILTER_MATCHING_RULE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_RULE_VALUE][129] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_VALUE, LdapStatesEnum.FILTER_MATCHING_TYPE_OR_MATCH_VALUE_TAG, new GrammarAction("Store matching rule Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                try {
                    extensibleMatchFilter.setMatchingRule(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The matching rule (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid matching rule " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG][130] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG, LdapStatesEnum.FILTER_MATCHING_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_TYPE_OR_MATCH_VALUE_TAG][130] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_RULE_OR_TYPE_TAG, LdapStatesEnum.FILTER_MATCHING_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_TYPE_VALUE][130] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_TYPE_VALUE, LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_TAG, new GrammarAction("Store matching type Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                try {
                    extensibleMatchFilter.setType(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The match filter (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid match filter " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + lsee.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_TAG][131] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_TAG, LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_VALUE][131] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_MATCH_VALUE_VALUE, LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_OR_END_TAG, new GrammarAction("Store matching match value Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                extensibleMatchFilter.setMatchValue(new OctetString(tlv.getValue().getData()));
            }
        });
        this.transitions[LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_OR_END_TAG][132] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_OR_END_TAG, LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_VALUE, null);
        this.transitions[LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_VALUE][132] = new GrammarTransition(LdapStatesEnum.FILTER_MATCHING_DN_ATTRIBUTES_VALUE, -1, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getCurrentFilter();
                Value value = tlv.getValue();
                try {
                    extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The DN attributes flag " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("DN Attributes : " + extensibleMatchFilter.isDnAttributes());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }

    private void unstackFilters(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Filter currentFilter = searchRequest.getCurrentFilter();
        if (tlv.getParent().getExpectedLength() == 0) {
            TLV parent = tlv.getParent();
            while (parent != null && parent.getExpectedLength() == 0) {
                parent = parent.getParent();
                if (currentFilter.getParent() instanceof Filter) {
                    currentFilter = (Filter)currentFilter.getParent();
                    continue;
                }
                currentFilter = null;
                break;
            }
            searchRequest.setCurrentFilter(currentFilter);
        }
    }

    private void compareFilterAction(IAsn1Container container, int filterType) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(filterType);
        Filter currentFilter = searchRequest.getCurrentFilter();
        if (currentFilter != null) {
            ((ConnectorFilter)currentFilter).addFilter(filter);
            filter.setParent(currentFilter);
        } else {
            filter.setParent(searchRequest);
            searchRequest.setFilter(filter);
        }
        searchRequest.setCurrentFilter(filter);
    }
}

