/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.Control;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.BooleanDecoder;
import org.apache.asn1new.util.BooleanDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapControlGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)LdapControlGrammar.class);
    private static IGrammar instance = new LdapControlGrammar();

    public static IGrammar getInstance() {
        return instance;
    }

    private LdapControlGrammar() {
        this.name = LdapControlGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_CONTROL_STATE][256];
        this.transitions[LdapStatesEnum.CONTROLS_TAG][160] = new GrammarTransition(LdapStatesEnum.CONTROLS_TAG, LdapStatesEnum.CONTROLS_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROLS_VALUE][160] = new GrammarTransition(LdapStatesEnum.CONTROLS_VALUE, LdapStatesEnum.CONTROL_TAG, new GrammarAction("Init Controls"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.initControl();
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_END_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_VALUE][48] = new GrammarTransition(LdapStatesEnum.CONTROL_VALUE, LdapStatesEnum.CONTROL_TYPE_TAG, new GrammarAction("Add Control"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                Control control = new Control();
                ldapMessage.addControl(control);
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_TYPE_TAG, LdapStatesEnum.CONTROL_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.CONTROL_TYPE_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, new GrammarAction("Set Control type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = ldapMessage.getCurrentControl();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The name must not be null");
                    throw new DecoderException("The name must not be null");
                }
                control.setControlType(new OID(tlv.getValue().getData()));
                if (log.isDebugEnabled()) {
                    log.debug("Control OID : " + control.getControlType());
                }
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][1] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, LdapStatesEnum.CONTROL_CRITICALITY_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_CRITICALITY_VALUE][1] = new GrammarTransition(LdapStatesEnum.CONTROL_CRITICALITY_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG, new GrammarAction("Set Control criticality"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = ldapMessage.getCurrentControl();
                Value value = tlv.getValue();
                try {
                    control.setCriticality(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The control criticality flag " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Control criticality : " + control.getCriticality());
                }
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, LdapStatesEnum.CONTROL_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG, LdapStatesEnum.CONTROL_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.CONTROL_VALUE_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, new GrammarAction("Set Control value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = ldapMessage.getCurrentControl();
                Value value = tlv.getValue();
                if (tlv.getLength().getLength() == 0) {
                    control.setControlValue(OctetString.EMPTY_STRING);
                } else {
                    control.setControlValue(new OctetString(value.getData()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Control value : " + StringUtils.dumpBytes((byte[])control.getControlValue()));
                }
            }
        });
    }
}

