/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.util.IntegerDecoder;
import org.apache.asn1new.util.IntegerDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapMessageGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)LdapMessageGrammar.class);
    private static IGrammar instance = new LdapMessageGrammar();

    private LdapMessageGrammar() {
        this.name = LdapMessageGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_LDAP_MESSAGE_STATE][256];
        this.transitions[LdapStatesEnum.LDAP_MESSAGE_TAG][48] = new GrammarTransition(LdapStatesEnum.LDAP_MESSAGE_TAG, LdapStatesEnum.LDAP_MESSAGE_VALUE, new GrammarAction("LdapMessage Tag"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = new LdapMessage();
                ldapMessageContainer.setLdapMessage(ldapMessage);
            }
        });
        this.transitions[LdapStatesEnum.LDAP_MESSAGE_VALUE][48] = new GrammarTransition(LdapStatesEnum.LDAP_MESSAGE_VALUE, LdapStatesEnum.LDAP_MESSAGE_ID_TAG, null);
        this.transitions[LdapStatesEnum.LDAP_MESSAGE_ID_TAG][2] = new GrammarTransition(LdapStatesEnum.LDAP_MESSAGE_ID_TAG, LdapStatesEnum.LDAP_MESSAGE_ID_VALUE, null);
        this.transitions[LdapStatesEnum.LDAP_MESSAGE_ID_VALUE][2] = new GrammarTransition(LdapStatesEnum.LDAP_MESSAGE_ID_VALUE, LdapStatesEnum.PROTOCOL_OP_TAG, new GrammarAction("Store MessageId"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int messageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    ldapMessage.setMessageId(messageId);
                    if (log.isDebugEnabled()) {
                        log.debug("Ldap Message Id has been decoded : " + messageId);
                    }
                }
                catch (IntegerDecoderException ide) {
                    log.error("The Message Id " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + ide.getMessage() + ". The message ID must be between (0 .. 2 147 483 647)");
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][66] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 1536, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][74] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 5376, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][80] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 1792, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][96] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 1024, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][97] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 1280, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][99] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 3584, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][100] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 4096, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][101] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 3328, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][102] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 4352, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][103] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 2816, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][104] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 4864, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][105] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 2048, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][107] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 2560, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][108] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 5120, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][109] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 3072, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][110] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 5632, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][111] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 2304, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][115] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 4608, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][119] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 5888, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][120] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 6144, null);
        this.transitions[LdapStatesEnum.PROTOCOL_OP_TAG][160] = new GrammarTransition(LdapStatesEnum.PROTOCOL_OP_TAG, 768, null);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

