/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapRDN;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.ModifyDNRequest;
import org.apache.asn1new.util.BooleanDecoder;
import org.apache.asn1new.util.BooleanDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDNRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyDNRequestGrammar.class);
    private static IGrammar instance = new ModifyDNRequestGrammar();

    private ModifyDNRequestGrammar() {
        this.name = ModifyDNRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_DN_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_TAG][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_VALUE][108] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, new GrammarAction("Init Modify DN Request"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyDNRequest());
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_ENTRY_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, new GrammarAction("Store entry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN entry = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The entry must nut be null");
                }
                try {
                    entry = new LdapDN(tlv.getValue().getData());
                    modifyDNRequest.setEntry(entry);
                }
                catch (InvalidNameException ine) {
                    log.error("The DN to modify  (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Modifying DN " + entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, new GrammarAction("Store new RDN"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapRDN newRdn = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The newrdn must nut be null");
                }
                try {
                    newRdn = new LdapRDN(tlv.getValue().getData());
                    modifyDNRequest.setNewRDN(newRdn);
                }
                catch (InvalidNameException ine) {
                    log.error("The new RDN (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                    throw new DecoderException("Invalid RDN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Modifying with new RDN " + newRdn);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE][1] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_DELETE_OLD_RDN_VALUE, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, new GrammarAction("Store matching dnAttributes Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                Value value = tlv.getValue();
                try {
                    modifyDNRequest.setDeleteOldRDN(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The oldRDN flag " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                if (log.isDebugEnabled()) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        log.debug(" Old RDN attributes will be deleted");
                    } else {
                        log.debug(" Old RDN attributes will be retained");
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_TAG, LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE][128] = new GrammarTransition(LdapStatesEnum.MODIFY_DN_REQUEST_NEW_SUPERIOR_VALUE, -1, new GrammarAction("Store new superior"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyDNRequest modifyDNRequest = ldapMessage.getModifyDNRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN newSuperior = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() == 0) {
                    if (modifyDNRequest.isDeleteOldRDN()) {
                        throw new DecoderException("The new superior must nut be null if the flag 'delete old DN' is set to true");
                    }
                    log.warn("The new superior is null, so we will change the entry");
                    modifyDNRequest.setNewSuperior(newSuperior);
                } else {
                    try {
                        newSuperior = new LdapDN(tlv.getValue().getData());
                        modifyDNRequest.setNewSuperior(newSuperior);
                    }
                    catch (InvalidNameException ine) {
                        log.error("The new superior DN (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ") is invalid");
                        throw new DecoderException("Invalid DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("New superior DN " + newSuperior);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

