/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.ModifyRequest;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.IntegerDecoder;
import org.apache.asn1new.util.IntegerDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyRequestGrammar.class);
    private static IGrammar instance = new ModifyRequestGrammar();

    private ModifyRequestGrammar() {
        this.name = ModifyRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TAG][102] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TAG, LdapStatesEnum.MODIFY_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALUE][102] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALUE, LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG, new GrammarAction("Init ModifyRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyRequest());
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OBJECT_TAG, LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OBJECT_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG, new GrammarAction("Store Modify request object Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    modifyRequest.setObject(LdapDN.EMPTY_LDAPDN);
                } else {
                    try {
                        modifyRequest.setObject(new LdapDN(tlv.getValue().getData()));
                    }
                    catch (InvalidNameException ine) {
                        log.error("Invalid DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", : " + ine.getMessage());
                        throw new DecoderException("Invalid object DN : " + ine.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Modification of DN " + modifyRequest.getObject());
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATIONS_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG, new GrammarAction("Init modifications array list"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                modifyRequest.initModifications();
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_SEQUENCE_VALUE, LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG][10] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OPERATION_TAG, LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE][10] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_OPERATION_VALUE, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG, new GrammarAction("Store operation type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                int operation = 0;
                try {
                    operation = IntegerDecoder.parse((Value)tlv.getValue(), (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    log.error("Invalid operation (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", it should be 0, 1 or 2 ");
                    throw new DecoderException("Invalid operation (" + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + ", it should be 0, 1 or 2 ");
                }
                modifyRequest.setCurrentOperation(operation);
                if (log.isDebugEnabled()) {
                    switch (operation) {
                        case 0: {
                            log.debug("Modification operation : ADD");
                            break;
                        }
                        case 1: {
                            log.debug("Modification operation : DELETE");
                            break;
                        }
                        case 2: {
                            log.debug("Modification operation : REPLACE");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_MODIFICATION_VALUE, LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TYPE_TAG, LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_TYPE_VALUE, LdapStatesEnum.MODIFY_REQUEST_VALS_TAG, new GrammarAction("Store type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString type = null;
                if (tlv.getLength().getLength() == 0) {
                    throw new DecoderException("The type can't be null");
                }
                try {
                    type = new LdapString(tlv.getValue().getData());
                    modifyRequest.addAttributeTypeAndValues(type);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("Invalid type : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()));
                    throw new DecoderException("Invalid type : " + lsee.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Modifying type : " + type);
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_TAG, LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_VALS_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_TAG, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_VALUE, LdapStatesEnum.MODIFY_REQUEST_ATTRIBUTE_VALUE_OR_MODIFICATION_TAG, new GrammarAction("Store value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ModifyRequest modifyRequest = ldapMessage.getModifyRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                OctetString value = OctetString.EMPTY_STRING;
                if (tlv.getLength().getLength() == 0) {
                    modifyRequest.addAttributeValue(value);
                } else {
                    value = new OctetString(tlv.getValue().getData());
                    modifyRequest.addAttributeValue(value);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Value modified : " + value);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

