/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.ModifyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)ModifyResponseGrammar.class);
    private static IGrammar instance = new ModifyResponseGrammar();

    private ModifyResponseGrammar() {
        this.name = ModifyResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_MODIFY_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.MODIFY_RESPONSE_TAG][103] = new GrammarTransition(LdapStatesEnum.MODIFY_RESPONSE_TAG, LdapStatesEnum.MODIFY_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.MODIFY_RESPONSE_VALUE][103] = new GrammarTransition(LdapStatesEnum.MODIFY_RESPONSE_VALUE, LdapStatesEnum.MODIFY_RESPONSE_LDAP_RESULT, new GrammarAction("Init ModifyResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new ModifyResponse());
                if (log.isDebugEnabled()) {
                    log.debug("Modify response");
                }
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.MODIFY_RESPONSE_LDAP_RESULT, 512, null);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

