/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SearchRequest;
import org.apache.asn1new.util.BooleanDecoder;
import org.apache.asn1new.util.BooleanDecoderException;
import org.apache.asn1new.util.IntegerDecoder;
import org.apache.asn1new.util.IntegerDecoderException;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchRequestGrammar.class);
    private static IGrammar instance = new SearchRequestGrammar();

    private SearchRequestGrammar() {
        this.name = SearchRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TAG][99] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TAG, LdapStatesEnum.SEARCH_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_VALUE][99] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_VALUE, LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG, new GrammarAction("Init SearchRequest"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchRequest());
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG, LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE, LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG, new GrammarAction("store base object value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN baseObject = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() != 0) {
                    try {
                        baseObject = new LdapDN(tlv.getValue().getData());
                    }
                    catch (InvalidNameException ine) {
                        log.error("The root DN " + baseObject.toString() + " is invalid");
                        throw new DecoderException("The root DN " + baseObject.toString() + " is invalid");
                    }
                }
                searchRequest.setBaseObject(baseObject);
                if (log.isDebugEnabled()) {
                    log.debug("Searching with root DN : " + baseObject);
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG, LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE, LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG, new GrammarAction("store scope value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int scope = 0;
                try {
                    scope = IntegerDecoder.parse((Value)value, (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The scope is not in [0..2] : " + value.toString());
                    throw new DecoderException("The scope is not in [0..2] : " + value.toString());
                }
                searchRequest.setScope(scope);
                if (log.isDebugEnabled()) {
                    switch (scope) {
                        case 0: {
                            log.debug("Searching within BASE_OBJECT scope ");
                            break;
                        }
                        case 1: {
                            log.debug("Searching within SINGLE_LEVEL scope ");
                            break;
                        }
                        case 2: {
                            log.debug("Searching within WHOLE_SUBTREE scope ");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG, LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE, LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG, new GrammarAction("store derefAliases value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int derefAliases = 0;
                try {
                    derefAliases = IntegerDecoder.parse((Value)value, (int)0, (int)3);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The derefAlias is not in [0..3] : " + value.toString());
                    throw new DecoderException("The derefAlias is not in [0..3] : " + value.toString());
                }
                searchRequest.setDerefAliases(derefAliases);
                if (log.isDebugEnabled()) {
                    switch (derefAliases) {
                        case 0: {
                            log.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                            break;
                        }
                        case 1: {
                            log.debug("Handling object strategy : DEREF_IN_SEARCHING");
                            break;
                        }
                        case 2: {
                            log.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                            break;
                        }
                        case 3: {
                            log.debug("Handling object strategy : DEREF_ALWAYS");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG, LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE, LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG, new GrammarAction("store sizeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int sizeLimit = 0;
                try {
                    sizeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The sizeLimit is not a valid Integer: " + value.toString());
                    throw new DecoderException("The sizeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setSizeLimit(sizeLimit);
                if (log.isDebugEnabled()) {
                    log.debug("The sizeLimit value is set to " + sizeLimit + " objects");
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG, LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE, LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG, new GrammarAction("store timeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int timeLimit = 0;
                try {
                    timeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The timeLimit is not a valid Integer: " + value.toString());
                    throw new DecoderException("The timeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setTimeLimit(timeLimit);
                if (log.isDebugEnabled()) {
                    log.debug("The timeLimit value is set to " + timeLimit + " seconds");
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG][1] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG, LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE][1] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE, LdapStatesEnum.SEARCH_REQUEST_FILTER, new GrammarAction("store typesOnly value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    searchRequest.setTypesOnly(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The types only flag " + StringUtils.dumpBytes((byte[])value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("The search will return " + (searchRequest.isTypesOnly() ? "only attributs type" : "attributes types and values"));
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][160] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][161] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][162] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][163] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][164] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][165] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][166] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][135] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][168] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][169] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][48] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, new GrammarAction("store Attribute Description List value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() != 0) {
                    searchRequest.initAttributes();
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, new GrammarAction("store Attribute Description value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString attributeDescription = null;
                try {
                    attributeDescription = new LdapString(tlv.getValue().getData());
                    searchRequest.addAttribute(attributeDescription);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("Cannot decode the attribute description : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()));
                    throw new DecoderException("Cannot decode the attribute description");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Decoded Attribute Description : " + attributeDescription.getString());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

