/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import javax.naming.InvalidNameException;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SearchResultEntry;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultEntryGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultEntryGrammar.class);
    private static IGrammar instance = new SearchResultEntryGrammar();

    private SearchResultEntryGrammar() {
        this.name = SearchResultEntryGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_RESULT_ENTRY_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TAG][100] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE][100] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG, new GrammarAction("Init SearchResultEntry"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchResultEntry());
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_OBJECT_NAME_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.setObjectName(LdapDN.EMPTY_LDAPDN);
                } else {
                    try {
                        searchResultEntry.setObjectName(new LdapDN(tlv.getValue().getData()));
                    }
                    catch (InvalidNameException ine) {
                        log.error(" The DN " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()) + "is invalid : " + ine.getMessage());
                        throw new DecoderException("The Dn is invalid : " + ine.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Search Result Entry DN found : " + searchResultEntry.getObjectName());
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTES_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_PARTIAL_ATTRIBUTE_LIST_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG, new GrammarAction("Store attributeValue"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                searchResultEntry.addPartialAttributeList();
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_TYPE_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG, new GrammarAction("Store search result entry object name Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString type = LdapString.EMPTY_STRING;
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.addAttributeValues(type);
                } else {
                    try {
                        type = new LdapString(tlv.getValue().getData());
                        searchResultEntry.addAttributeValues(type);
                    }
                    catch (LdapStringEncodingException lsee) {
                        log.error("Invalid attribute type : " + StringUtils.dumpBytes((byte[])tlv.getValue().getData()));
                        throw new DecoderException("The attribute type is invalid : " + lsee.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Attribute type : " + type);
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG][49] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE][49] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_VALS_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_TAG, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_VALUE, LdapStatesEnum.SEARCH_RESULT_ENTRY_ATTRIBUTE_VALUE_OR_LIST_TAG, new GrammarAction("Store Attribute Value value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultEntry searchResultEntry = ldapMessage.getSearchResultEntry();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                OctetString value = OctetString.EMPTY_STRING;
                if (tlv.getLength().getLength() == 0) {
                    searchResultEntry.addAttributeValue(value);
                } else {
                    value = new OctetString(tlv.getValue().getData());
                    searchResultEntry.addAttributeValue(value);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Attribute value : " + value);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

