/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.grammar;

import org.apache.asn1.codec.DecoderException;
import org.apache.asn1new.ber.containers.IAsn1Container;
import org.apache.asn1new.ber.grammar.AbstractGrammar;
import org.apache.asn1new.ber.grammar.GrammarAction;
import org.apache.asn1new.ber.grammar.GrammarTransition;
import org.apache.asn1new.ber.grammar.IGrammar;
import org.apache.asn1new.ber.tlv.TLV;
import org.apache.asn1new.ldap.codec.LdapMessageContainer;
import org.apache.asn1new.ldap.codec.grammar.LdapStatesEnum;
import org.apache.asn1new.ldap.codec.primitives.LdapURL;
import org.apache.asn1new.ldap.codec.primitives.LdapURLEncodingException;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SearchResultReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultReferenceGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultReferenceGrammar.class);
    private static IGrammar instance = new SearchResultReferenceGrammar();

    private SearchResultReferenceGrammar() {
        this.name = SearchResultReferenceGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_RESULT_REFERENCE_STATE_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_TAG][115] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE][115] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_VALUE, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG, new GrammarAction("Init SearchResultReference"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchResultReference searchResultReference = new SearchResultReference();
                searchResultReference.setParent(ldapMessage);
                ldapMessage.setProtocolOP(searchResultReference);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_RESULT_REFERENCE_LDAP_URL_VALUE, LdapStatesEnum.SEARCH_RESULT_REFERENCE_LOOP_OR_END_TAG, new GrammarAction("Store ldapUrl value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchResultReference searchResultReference = ldapMessageContainer.getLdapMessage().getSearchResultReference();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapURL url = LdapURL.EMPTY_URL;
                if (tlv.getLength().getLength() == 0) {
                    searchResultReference.addSearchResultReference(url);
                } else {
                    try {
                        url = new LdapURL(tlv.getValue().getData());
                        searchResultReference.addSearchResultReference(url);
                    }
                    catch (LdapURLEncodingException luee) {
                        String badUrl = new String(tlv.getValue().getData());
                        log.error("The URL " + badUrl + " is not valid : " + luee.getMessage());
                        throw new DecoderException("Invalid URL : " + luee.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Search reference URL found : " + url);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

