/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import javax.naming.InvalidNameException;
import org.apache.commons.lang.StringUtils;

public class AttributeTypeAndValue
implements Cloneable,
Comparable {
    private String type;
    private String value;

    public AttributeTypeAndValue() {
        this.type = null;
        this.value = null;
    }

    public AttributeTypeAndValue(String type, String value) throws InvalidNameException {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws InvalidNameException {
        if (StringUtils.isEmpty((String)type)) {
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null : ");
        }
        this.type = type;
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        this.type = StringUtils.lowerCase((String)StringUtils.trim((String)type));
        if (StringUtils.isEmpty((String)this.type)) {
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null : ");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtils.isEmpty((String)value) ? "" : value;
    }

    public void setValueNormalized(String value) {
        this.value = StringUtils.trim((String)value);
        if (StringUtils.isEmpty((String)value)) {
            this.value = "";
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            return this.compare(this.type, nc.type) && this.compare(this.value, nc.value) ? 0 : -1;
        }
        return -1;
    }

    private boolean compare(String val1, String val2) {
        if (StringUtils.isEmpty((String)val1)) {
            return StringUtils.isEmpty((String)val2);
        }
        if (StringUtils.isEmpty((String)val2)) {
            return false;
        }
        return StringUtils.lowerCase((String)StringUtils.trim((String)val1)).equals(StringUtils.lowerCase((String)StringUtils.trim((String)val2)));
    }

    public String normalize() {
        return StringUtils.lowerCase((String)StringUtils.trim((String)this.type)) + '=' + StringUtils.trim((String)this.value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type).append("=").append(this.value);
        return sb.toString();
    }
}

