/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapRDN;
import org.apache.asn1new.ldap.codec.primitives.RDNParser;
import org.apache.asn1new.util.StringUtils;

public class DNParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(String dn, List rdns) throws InvalidNameException {
        char[] chars = dn.trim().toCharArray();
        if (chars.length == 0) {
            return;
        }
        int pos = 0;
        LdapRDN rdn = new LdapRDN();
        if ((pos = RDNParser.parse(chars, pos, rdn)) == -1) throw new InvalidNameException("Bad DN : " + new String(chars));
        do {
            rdns.add(rdn.clone());
            rdn.clear();
            if (!StringUtils.isCharASCII((char[])chars, (int)pos, (char)',') && !StringUtils.isCharASCII((char[])chars, (int)pos, (char)';')) return;
            chars[pos] = 44;
            ++pos;
        } while ((pos = RDNParser.parse(chars, pos, rdn)) != -1);
    }

    public static LdapDN parse(String dn) throws InvalidNameException {
        return new LdapDN(dn);
    }
}

