/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.asn1new.ldap.codec.primitives.DNParser;
import org.apache.asn1new.ldap.codec.primitives.LdapRDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.util.StringUtils;

public class LdapDN
extends LdapString
implements Name {
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUALS = -1;
    public static final int EQUALS = 0;
    private List rdns = new ArrayList(5);
    private String upName;
    public static final transient LdapDN EMPTY_LDAPDN = new LdapDN();

    public LdapDN() {
        this.upName = "";
    }

    public LdapDN(String string) throws InvalidNameException {
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new InvalidNameException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
            }
            DNParser.parse(string, this.rdns);
        } else {
            this.string = "";
        }
        this.normalize();
        this.upName = string;
    }

    public LdapDN(byte[] bytes) throws InvalidNameException {
        try {
            this.upName = new String(bytes, "UTF-8");
            DNParser.parse(this.upName, this.rdns);
            this.string = this.toString();
            this.normalize();
        }
        catch (UnsupportedEncodingException uee) {
            throw new InvalidNameException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
    }

    private void normalize() {
        StringBuffer sb = new StringBuffer();
        if (this.rdns == null) {
            this.string = "";
        }
        Iterator elements = this.rdns.iterator();
        boolean isFirst = true;
        while (elements.hasNext()) {
            LdapRDN rdn = (LdapRDN)elements.next();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(rdn.toString());
        }
        this.string = sb.toString();
        try {
            this.bytes = this.string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.rdns == null || this.rdns.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < this.rdns.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append((LdapRDN)this.rdns.get(i));
        }
        return sb.toString();
    }

    public String getName() {
        return this.upName == null ? "" : this.upName;
    }

    public int size() {
        return this.rdns.size();
    }

    public boolean startsWith(Name name) {
        if (name instanceof LdapDN) {
            LdapDN nameDN = (LdapDN)name;
            if (nameDN.size() == 0) {
                return true;
            }
            if (nameDN.size() > this.size()) {
                return false;
            }
            for (int i = nameDN.size() - 1; i >= 0; --i) {
                LdapRDN ldapRdn;
                LdapRDN nameRdn = (LdapRDN)nameDN.rdns.get(nameDN.rdns.size() - i - 1);
                if (nameRdn.compareTo(ldapRdn = (LdapRDN)this.rdns.get(this.rdns.size() - i - 1)) == 0) continue;
                return false;
            }
            return true;
        }
        return name == null;
    }

    public boolean endsWith(Name name) {
        if (name instanceof LdapDN) {
            LdapDN nameDN = (LdapDN)name;
            if (nameDN.size() == 0) {
                return true;
            }
            if (nameDN.size() > this.size()) {
                return false;
            }
            for (int i = 0; i < nameDN.size(); ++i) {
                LdapRDN ldapRdn;
                LdapRDN nameRdn = (LdapRDN)nameDN.rdns.get(i);
                if (nameRdn.compareTo(ldapRdn = (LdapRDN)this.rdns.get(i)) == 0) continue;
                return false;
            }
            return true;
        }
        return name == null;
    }

    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    public String get(int posn) {
        if (this.rdns.size() == 0) {
            return "";
        }
        LdapRDN rdn = (LdapRDN)this.rdns.get(this.rdns.size() - posn - 1);
        return rdn.toString();
    }

    public Enumeration getAll() {
        return new Enumeration(){
            private int pos;

            public boolean hasMoreElements() {
                return this.pos < LdapDN.this.rdns.size();
            }

            public Object nextElement() {
                if (this.pos >= LdapDN.this.rdns.size()) {
                    throw new NoSuchElementException();
                }
                String obj = LdapDN.this.get(this.pos);
                ++this.pos;
                return obj;
            }
        };
    }

    public Name getPrefix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            throw new ArrayIndexOutOfBoundsException("The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]");
        }
        LdapDN newLdapDN = new LdapDN();
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newLdapDN.rdns.add(((LdapRDN)this.rdns.get(i)).clone());
        }
        newLdapDN.normalize();
        newLdapDN.upName = newLdapDN.string = newLdapDN.toString();
        return newLdapDN;
    }

    public Name getSuffix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            throw new ArrayIndexOutOfBoundsException("The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]");
        }
        LdapDN newLdapDN = new LdapDN();
        for (int i = 0; i < this.size() - posn; ++i) {
            newLdapDN.rdns.add(((LdapRDN)this.rdns.get(i)).clone());
        }
        newLdapDN.normalize();
        newLdapDN.upName = newLdapDN.string = newLdapDN.toString();
        return newLdapDN;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        this.addAll(this.rdns.size(), suffix);
        return this;
    }

    public Name addAll(int posn, Name name) throws InvalidNameException {
        if (name instanceof LdapDN) {
            if (name == null || name.size() == 0) {
                return this;
            }
            this.rdns.addAll(this.size() - posn, ((LdapDN)name).rdns);
            this.normalize();
            this.upName = this.toString();
            return this;
        }
        throw new InvalidNameException("The suffix is not a LdapDN");
    }

    public Name add(String comp) throws InvalidNameException {
        LdapRDN newRdn = new LdapRDN(comp);
        this.rdns.add(0, newRdn);
        this.normalize();
        this.upName = this.toString();
        return this;
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        if (posn < 0 || posn > this.size()) {
            throw new ArrayIndexOutOfBoundsException("The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]");
        }
        LdapRDN newRdn = new LdapRDN(comp);
        int realPos = this.size() - posn;
        this.rdns.add(realPos, newRdn);
        this.normalize();
        this.upName = this.toString();
        return this;
    }

    public Object remove(int posn) throws InvalidNameException {
        if (this.rdns.size() == 0) {
            return EMPTY_LDAPDN;
        }
        if (posn < 0 || posn >= this.rdns.size()) {
            throw new ArrayIndexOutOfBoundsException("The posn(" + posn + ") should be in the range [0, " + this.rdns.size() + "]");
        }
        int realPos = this.size() - posn - 1;
        LdapRDN rdn = (LdapRDN)this.rdns.remove(realPos);
        this.normalize();
        this.upName = this.toString();
        return rdn;
    }

    public Object clone() {
        try {
            LdapDN dn = (LdapDN)super.clone();
            for (int i = 0; i < this.rdns.size(); ++i) {
                dn.rdns.set(i, ((LdapRDN)this.rdns.get(i)).clone());
            }
            return dn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.toString().equals(obj);
        }
        if (obj instanceof LdapDN) {
            LdapDN name = (LdapDN)obj;
            if (name.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (((LdapRDN)name.rdns.get(i)).compareTo(this.rdns.get(i)) != -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof LdapDN) {
            LdapDN ldapDN = (LdapDN)obj;
            if (ldapDN.size() != this.size()) {
                return -1;
            }
            Iterator dn1Iter = this.rdns.iterator();
            Iterator dn2Iter = ldapDN.rdns.iterator();
            while (dn1Iter.hasNext() && dn2Iter.hasNext()) {
                LdapRDN rdn2;
                LdapRDN rdn1 = (LdapRDN)dn1Iter.next();
                if (rdn1.compareTo(rdn2 = (LdapRDN)dn2Iter.next()) != -1) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }
}

