/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.asn1new.ldap.codec.primitives.AttributeTypeAndValue;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.codec.primitives.RDNParser;
import org.apache.asn1new.util.StringUtils;
import org.apache.commons.collections.MultiHashMap;

public class LdapRDN
extends LdapString
implements Cloneable,
Comparable {
    private MultiHashMap atavs;
    private AttributeTypeAndValue atav;
    private transient int nbAtavs;
    public static final int NOT_EQUALS = -1;
    public static final int EQUALS = 0;

    public LdapRDN() {
        this.atavs = null;
        this.atav = null;
        this.nbAtavs = 0;
    }

    public LdapRDN(String rdn) throws InvalidNameException {
        if (StringUtils.isNotEmpty((String)rdn)) {
            try {
                rdn.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new InvalidNameException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
            }
            RDNParser.parse(rdn, this);
            this.normalize();
        }
    }

    public LdapRDN(byte[] bytes) throws InvalidNameException {
        try {
            RDNParser.parse(new String(bytes, "UTF-8"), this);
            this.normalize();
        }
        catch (UnsupportedEncodingException uee) {
            throw new InvalidNameException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
    }

    public LdapRDN(String type, String value) throws InvalidNameException {
        this.atavs = null;
        this.atav = new AttributeTypeAndValue(type, value);
        this.nbAtavs = 1;
        this.normalize();
    }

    private void normalize() {
        switch (this.nbAtavs) {
            case 0: {
                this.string = "";
                break;
            }
            case 1: {
                this.string = StringUtils.lowerCase((String)StringUtils.trim((String)this.atav.getType())) + '=' + StringUtils.trim((String)this.atav.getValue());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                Iterator elems = this.atavs.values().iterator();
                boolean isFirst = true;
                while (elems.hasNext()) {
                    AttributeTypeAndValue ata = (AttributeTypeAndValue)elems.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.normalize());
                }
                this.string = sb.toString();
            }
        }
        try {
            this.bytes = this.string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void addAttributeTypeAndValue(String type, String value) throws InvalidNameException {
        String normalizedType = StringUtils.lowerCase((String)StringUtils.trim((String)type));
        String normalizedValue = StringUtils.trim((String)value);
        switch (this.nbAtavs) {
            case 0: {
                this.atav = new AttributeTypeAndValue(normalizedType, normalizedValue);
                this.nbAtavs = 1;
                break;
            }
            case 1: {
                this.atavs = new MultiHashMap();
                this.atavs.put((Object)this.atav.getType(), (Object)this.atav);
                this.atav = null;
                this.atavs.put((Object)normalizedType, (Object)new AttributeTypeAndValue(normalizedType, normalizedValue));
                this.nbAtavs = 2;
                break;
            }
            default: {
                this.atavs.put((Object)normalizedType, (Object)new AttributeTypeAndValue(normalizedType, normalizedValue));
                ++this.nbAtavs;
            }
        }
        this.string = StringUtils.isEmpty((String)this.string) ? normalizedType + '=' + normalizedValue : this.string + '+' + normalizedType + '=' + normalizedValue;
    }

    public void removeAttributeTypeAndValue(String type) throws InvalidNameException {
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        String normalizedType = StringUtils.lowerCase((String)StringUtils.trim((String)type));
        switch (this.nbAtavs) {
            case 0: {
                throw new InvalidNameException("Cannot remove a AttributeTypeAndValue form an empty RDN");
            }
            case 1: {
                if (normalizedType.equals(this.atav.getType())) {
                    this.atav = null;
                    this.string = "";
                    --this.nbAtavs;
                    break;
                }
                throw new InvalidNameException("Name '" + normalizedType + "' is not valid for the RDN '" + this.toString() + "'");
            }
            default: {
                if (this.atavs.containsKey((Object)normalizedType)) {
                    this.atavs.remove((Object)normalizedType);
                    this.normalize();
                    --this.nbAtavs;
                    break;
                }
                throw new InvalidNameException("Name '" + normalizedType + "' is not valid for the RDN '" + this.toString() + "'");
            }
        }
    }

    public void clear() {
        this.atav = null;
        this.atavs = null;
        this.nbAtavs = 0;
        this.string = "";
        this.bytes = EMPTY_BYTES;
    }

    public String getValue(String type) throws InvalidNameException {
        String normalizedType = StringUtils.lowerCase((String)StringUtils.trim((String)type));
        switch (this.nbAtavs) {
            case 0: {
                return "";
            }
            case 1: {
                if (StringUtils.equals((String)this.atav.getType(), (String)normalizedType)) {
                    return this.atav.getValue();
                }
                return "";
            }
        }
        if (this.atavs.containsKey((Object)normalizedType)) {
            ArrayList avas = (ArrayList)this.atavs.get((Object)normalizedType);
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (int i = 0; i < avas.size(); ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(((AttributeTypeAndValue)avas.get(i)).getValue());
            }
            return sb.toString();
        }
        return "";
    }

    public AttributeTypeAndValue getAttributeTypeAndValue(String type) {
        String normalizedType = StringUtils.lowerCase((String)StringUtils.trim((String)type));
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.atav.getType().equals(normalizedType)) {
                    return this.atav;
                }
                return null;
            }
        }
        if (this.atavs.containsKey((Object)normalizedType)) {
            ArrayList values = (ArrayList)this.atavs.get((Object)normalizedType);
            return (AttributeTypeAndValue)values.get(0);
        }
        return null;
    }

    public Object clone() {
        try {
            LdapRDN rdn = (LdapRDN)super.clone();
            if (this.atavs != null) {
                rdn.atavs = new MultiHashMap(this.nbAtavs);
                Iterator values = this.atavs.values().iterator();
                while (values.hasNext()) {
                    AttributeTypeAndValue ava = (AttributeTypeAndValue)values.next();
                    rdn.atavs.put((Object)ava.getType(), (Object)ava);
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof LdapRDN) {
            LdapRDN rdn = (LdapRDN)object;
            if (rdn == null || rdn.nbAtavs != this.nbAtavs) {
                return -1;
            }
            switch (this.nbAtavs) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return this.atav.compareTo(rdn.atav);
                }
            }
            Iterator keys = this.atavs.keySet().iterator();
            while (keys.hasNext()) {
                String type = (String)keys.next();
                if (!rdn.atavs.containsKey((Object)type)) continue;
                List atavList = (List)this.atavs.get((Object)type);
                List atavList2 = (List)rdn.atavs.get((Object)type);
                Iterator atavIter1 = atavList.iterator();
                HashSet<String> atavSet = new HashSet<String>();
                while (atavIter1.hasNext()) {
                    AttributeTypeAndValue atavValue = (AttributeTypeAndValue)atavIter1.next();
                    atavSet.add(StringUtils.lowerCase((String)atavValue.getValue()));
                }
                Iterator atavIter2 = atavList2.iterator();
                while (atavIter2.hasNext()) {
                    AttributeTypeAndValue atavValue = (AttributeTypeAndValue)atavIter2.next();
                    if (atavSet.contains(StringUtils.lowerCase((String)atavValue.getValue()))) {
                        atavSet.remove(StringUtils.lowerCase((String)atavValue.getValue()));
                        continue;
                    }
                    return -1;
                }
                if (atavSet.size() == 0) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        return this.string;
    }

    public int getNbAtavs() {
        return this.nbAtavs;
    }
}

