/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import java.io.UnsupportedEncodingException;
import org.apache.asn1new.ldap.codec.primitives.LdapStringEncodingException;

public class LdapString {
    public static final transient LdapString EMPTY_STRING = new LdapString();
    public static final transient byte[] EMPTY_BYTES = new byte[0];
    protected String string;
    protected byte[] bytes;

    public LdapString() {
        this.bytes = EMPTY_BYTES;
        this.string = "";
    }

    public LdapString(byte[] bytes) throws LdapStringEncodingException {
        try {
            this.string = new String(bytes, "UTF-8");
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdapStringEncodingException("The byte array is not an UTF-8 encoded Unicode String : " + uee.getMessage());
        }
    }

    public String getString() {
        return this.string;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getNbBytes() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public String toString() {
        return this.string;
    }
}

