/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.primitives;

import javax.naming.InvalidNameException;
import org.apache.asn1new.ldap.codec.primitives.LdapRDN;
import org.apache.asn1new.ldap.codec.utils.DNUtils;
import org.apache.asn1new.util.StringUtils;

public class RDNParser {
    private static int parseOidValue(char[] chars, int pos) {
        if (!StringUtils.isDigit((char[])chars, (int)pos)) {
            return -1;
        }
        ++pos;
        while (StringUtils.isDigit((char[])chars, (int)pos)) {
            ++pos;
        }
        if (!StringUtils.isCharASCII((char[])chars, (int)pos, (char)'.')) {
            return pos;
        }
        do {
            if (!StringUtils.isDigit((char[])chars, (int)(++pos))) {
                return -1;
            }
            ++pos;
            while (StringUtils.isDigit((char[])chars, (int)pos)) {
                ++pos;
            }
        } while (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'.'));
        return pos;
    }

    private static int parseOidPrefix(char[] chars, int pos) {
        if (StringUtils.areEquals((char[])chars, (int)pos, (char[])DNUtils.OID_LOWER) == -1 && StringUtils.areEquals((char[])chars, (int)pos, (char[])DNUtils.OID_UPPER) == -1) {
            return -1;
        }
        return pos += DNUtils.OID_LOWER.length;
    }

    private static int parseAttributeType(char[] chars, int pos) {
        if (StringUtils.isAlphaASCII((char[])chars, (int)pos)) {
            int oldPos = pos;
            if ((pos = RDNParser.parseOidPrefix(chars, oldPos)) != -1) {
                return RDNParser.parseOidValue(chars, pos);
            }
            pos = oldPos + 1;
            while (StringUtils.isAlphaDigitMinus((char[])chars, (int)pos)) {
                ++pos;
            }
            return pos;
        }
        return RDNParser.parseOidValue(chars, pos);
    }

    private static int parseAttributeValue(char[] chars, int pos) {
        if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'#')) {
            ++pos;
            if ((pos = DNUtils.parseHexString(chars, pos)) == -1) {
                return -1;
            }
            return StringUtils.trimLeft((char[])chars, (int)pos);
        }
        if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'\"')) {
            ++pos;
            int nbBytes = 0;
            while (true) {
                if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'\\')) {
                    if (DNUtils.isPairChar(chars, ++pos)) {
                        ++pos;
                        continue;
                    }
                    return -1;
                }
                nbBytes = DNUtils.isQuoteChar(chars, pos);
                if (nbBytes == -1) break;
                pos += nbBytes;
            }
            if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'\"')) {
                return StringUtils.trimLeft((char[])chars, (int)(++pos));
            }
            return -1;
        }
        while (true) {
            if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)'\\')) {
                if (!DNUtils.isPairChar(chars, ++pos)) {
                    return -1;
                }
                ++pos;
                continue;
            }
            int nbChars = 0;
            nbChars = DNUtils.isStringChar(chars, pos);
            if (nbChars == -1) break;
            if (StringUtils.isCharASCII((char[])chars, (int)pos, (char)' ')) {
                if (DNUtils.isStringChar(chars, pos = StringUtils.trimLeft((char[])chars, (int)pos)) != -1 || StringUtils.isCharASCII((char[])chars, (int)pos, (char)'\\')) continue;
                return pos;
            }
            pos += nbChars;
        }
        return pos;
    }

    private static int parseNameComponents(char[] chars, int pos, LdapRDN rdn) throws InvalidNameException {
        int newPos = 0;
        String type = null;
        String value = null;
        while (true) {
            if (StringUtils.isCharASCII((char[])chars, (int)(pos = StringUtils.trimLeft((char[])chars, (int)pos)), (char)'+')) {
                ++pos;
            } else {
                return pos;
            }
            pos = StringUtils.trimLeft((char[])chars, (int)pos);
            newPos = RDNParser.parseAttributeType(chars, pos);
            if (newPos == -1) {
                return -1;
            }
            if (rdn != null) {
                type = new String(chars, pos, newPos - pos);
            }
            if (StringUtils.isCharASCII((char[])chars, (int)(pos = StringUtils.trimLeft((char[])chars, (int)newPos)), (char)'=')) {
                ++pos;
            } else {
                return -1;
            }
            pos = StringUtils.trimLeft((char[])chars, (int)pos);
            newPos = RDNParser.parseAttributeValue(chars, pos);
            if (newPos != -1 && rdn != null) {
                newPos = StringUtils.trimRight((char[])chars, (int)newPos);
                value = new String(chars, pos, newPos - pos);
                rdn.addAttributeTypeAndValue(type, value);
            }
            pos = newPos;
        }
    }

    public static int parse(char[] chars, int pos, LdapRDN rdn) throws InvalidNameException {
        int newPos = 0;
        String type = null;
        String value = null;
        newPos = RDNParser.parseAttributeType(chars, pos = StringUtils.trimLeft((char[])chars, (int)pos));
        if (newPos == -1) {
            return -1;
        }
        if (rdn != null) {
            type = new String(chars, pos, newPos - pos);
        }
        if (!StringUtils.isCharASCII((char[])chars, (int)(pos = StringUtils.trimLeft((char[])chars, (int)newPos)), (char)'=')) {
            return -1;
        }
        ++pos;
        newPos = RDNParser.parseAttributeValue(chars, pos = StringUtils.trimLeft((char[])chars, (int)pos));
        if (newPos == -1) {
            return -1;
        }
        if (rdn != null) {
            newPos = StringUtils.trimRight((char[])chars, (int)newPos);
            value = new String(chars, pos, newPos - pos);
            rdn.addAttributeTypeAndValue(type, value);
        }
        int end = RDNParser.parseNameComponents(chars, newPos, rdn);
        return end;
    }

    public static void parse(String string, LdapRDN rdn) throws InvalidNameException {
        RDNParser.parse(string.toCharArray(), 0, rdn);
    }
}

