/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.codec.utils;

import org.apache.asn1new.util.StringUtils;

public class DNUtils {
    private static final boolean[] SAFE_INIT_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] SAFE_CHAR = new boolean[]{false, true, true, true, true, true, true, true, true, true, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final boolean[] BASE64_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final boolean[] PAIR_CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final char[] OID_LOWER = new char[]{'o', 'i', 'd', '.'};
    public static final char[] OID_UPPER = new char[]{'O', 'I', 'D', '.'};
    public static final byte[] OID_LOWER_BYTES = new byte[]{111, 105, 100, 46};
    public static final byte[] OID_UPPER_BYTES = new byte[]{79, 73, 68, 46};
    public static final int PARSING_ERROR = -1;
    public static final int BAD_HEX_PAIR = -2;
    public static final int ONE_CHAR = 1;
    public static final int TWO_CHARS = 2;
    public static final int ONE_BYTE = 1;
    public static final int TWO_BYTES = 2;

    public static int parseSafeString(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c > 127 || !SAFE_INIT_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < byteArray.length && (c = byteArray[index]) <= 127 && SAFE_CHAR[c]) {
            ++index;
        }
        return index;
    }

    public static int parseAlphaASCII(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        if ((c = byteArray[index++]) > 127 || !StringUtils.ALPHA[c]) {
            return -1;
        }
        return index;
    }

    public static int parseAlphaASCII(char[] charArray, int index) {
        char c;
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        if ((c = charArray[index++]) > '\u007f' || !StringUtils.ALPHA[c]) {
            return -1;
        }
        return index;
    }

    public static boolean isPairChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        byte c = byteArray[index];
        if (c > 127 || !PAIR_CHAR[c]) {
            return false;
        }
        if (StringUtils.isHex((byte[])byteArray, (int)index++)) {
            return StringUtils.isHex((byte[])byteArray, (int)index);
        }
        return true;
    }

    public static boolean isPairChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return false;
        }
        char c = charArray[index];
        if (c > '\u007f' || !PAIR_CHAR[c]) {
            return false;
        }
        if (StringUtils.isHex((char[])charArray, (int)index++)) {
            return StringUtils.isHex((char[])charArray, (int)index);
        }
        return true;
    }

    public static int isStringChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c == 10 || c == 13 || c == 34 || c == 35 || c == 43 || c == 44 || c == 59 || c == 60 || c == 61 || c == 62) {
            return -1;
        }
        return StringUtils.countBytesPerChar((byte[])byteArray, (int)index);
    }

    public static int isStringChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        char c = charArray[index];
        if (c == '\n' || c == '\r' || c == '\"' || c == '#' || c == '+' || c == ',' || c == ';' || c == '<' || c == '=' || c == '>') {
            return -1;
        }
        return 1;
    }

    public static int isQuoteChar(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c == 92 || c == 34) {
            return -1;
        }
        return StringUtils.countBytesPerChar((byte[])byteArray, (int)index);
    }

    public static int isQuoteChar(char[] charArray, int index) {
        if (charArray == null || charArray.length == 0 || index < 0 || index >= charArray.length) {
            return -1;
        }
        char c = charArray[index];
        if (c == '\\' || c == '\"') {
            return -1;
        }
        return 1;
    }

    public static int parseHexPair(byte[] byteArray, int index) {
        if (StringUtils.isHex((byte[])byteArray, (int)index)) {
            if (StringUtils.isHex((byte[])byteArray, (int)(index + 1))) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    public static int parseHexPair(char[] charArray, int index) {
        if (StringUtils.isHex((char[])charArray, (int)index)) {
            if (StringUtils.isHex((char[])charArray, (int)(index + 1))) {
                return index + 2;
            }
            return -2;
        }
        return -1;
    }

    public static int parseHexString(byte[] byteArray, int index) {
        int result = DNUtils.parseHexPair(byteArray, index);
        if (result < 0) {
            return -1;
        }
        index += 2;
        while ((result = DNUtils.parseHexPair(byteArray, index)) >= 0) {
            index += 2;
        }
        return result == -2 ? -1 : index;
    }

    public static int parseHexString(char[] charArray, int index) {
        int result = DNUtils.parseHexPair(charArray, index);
        if (result < 0) {
            return -1;
        }
        index += 2;
        while ((result = DNUtils.parseHexPair(charArray, index)) >= 0) {
            index += 2;
        }
        return result == -2 ? -1 : index;
    }

    public static int parseBase64String(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return -1;
        }
        byte c = byteArray[index];
        if (c > 127 || !BASE64_CHAR[c]) {
            return -1;
        }
        ++index;
        while (index < byteArray.length && (c = byteArray[index]) <= 127 && BASE64_CHAR[c]) {
            ++index;
        }
        return index;
    }
}

