/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonRequest
extends LdapMessage {
    private static Logger log = LoggerFactory.getLogger((Class)AbandonRequest.class);
    private int abandonedMessageId;

    public int getAbandonedMessageId() {
        return this.abandonedMessageId;
    }

    public int getMessageType() {
        return 0;
    }

    public void setAbandonedMessageId(int abandonedMessageId) {
        this.abandonedMessageId = abandonedMessageId;
    }

    public int computeLength() {
        int length = 2 + Value.getNbBytes((int)this.abandonedMessageId);
        if (log.isDebugEnabled()) {
            log.debug("Message length : " + length);
        }
        return length;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)80);
            buffer.put((byte)Value.getNbBytes((int)this.abandonedMessageId));
            buffer.put(Value.getBytes((int)this.abandonedMessageId));
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Abandon Request :\n");
        sb.append("        Message Id : ").append(this.abandonedMessageId).append('\n');
        return sb.toString();
    }
}

