/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;
import org.apache.asn1new.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequest
extends LdapMessage {
    private static final transient Logger log = LoggerFactory.getLogger((Class)AddRequest.class);
    private LdapDN entry;
    private Attributes attributes;
    private transient Attribute currentAttribute;
    private transient int addRequestLength;
    private transient int attributesLength;
    private transient List attributeLength;
    private transient List valuesLength;

    public int getMessageType() {
        return 1;
    }

    public void initAttributes() {
        this.attributes = new BasicAttributes(true);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void addAttributeType(LdapString type) {
        this.currentAttribute = new BasicAttribute(type.getString().toLowerCase());
        this.attributes.put(this.currentAttribute);
    }

    public void addAttributeValue(OctetString value) {
        this.currentAttribute.add(value);
    }

    public String getEntry() {
        return this.entry == null ? "" : this.entry.getString();
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public int computeLength() {
        this.addRequestLength = 1 + Length.getNbBytes((int)this.entry.getNbBytes()) + this.entry.getNbBytes();
        this.attributesLength = 0;
        if (this.attributes != null && this.attributes.size() != 0) {
            NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
            this.attributeLength = new LinkedList();
            this.valuesLength = new LinkedList();
            while (attributeIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributeIterator.nextElement();
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getID().getBytes().length;
                localAttributeLength = 1 + Length.getNbBytes((int)idLength) + idLength;
                try {
                    NamingEnumeration<?> values = attribute.getAll();
                    if (values.hasMoreElements()) {
                        localValuesLength = 0;
                        while (values.hasMoreElements()) {
                            OctetString value = (OctetString)values.next();
                            localValuesLength += 1 + Length.getNbBytes((int)value.getNbBytes()) + value.getNbBytes();
                        }
                        localAttributeLength += 1 + Length.getNbBytes((int)localValuesLength) + localValuesLength;
                    }
                }
                catch (NamingException ne) {
                    return 0;
                }
                this.attributesLength += 1 + Length.getNbBytes((int)localAttributeLength) + localAttributeLength;
                this.attributeLength.add(new Integer(localAttributeLength));
                this.valuesLength.add(new Integer(localValuesLength));
            }
        }
        this.addRequestLength += 1 + Length.getNbBytes((int)this.attributesLength) + this.attributesLength;
        int result = 1 + Length.getNbBytes((int)this.addRequestLength) + this.addRequestLength;
        if (log.isDebugEnabled()) {
            log.debug("AddRequest PDU length = " + result);
        }
        return result;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        block9: {
            if (buffer == null) {
                throw new EncoderException("Cannot put a PDU in a null buffer !");
            }
            try {
                buffer.put((byte)104);
                buffer.put(Length.getBytes((int)this.addRequestLength));
                Value.encode((ByteBuffer)buffer, (byte[])this.entry.getBytes());
                buffer.put((byte)48);
                buffer.put(Length.getBytes((int)this.attributesLength));
                if (this.attributes == null || this.attributes.size() == 0) break block9;
                NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
                int attributeNumber = 0;
                while (attributeIterator.hasMoreElements()) {
                    Attribute attribute = (Attribute)attributeIterator.nextElement();
                    buffer.put((byte)48);
                    int localAttributeLength = (Integer)this.attributeLength.get(attributeNumber);
                    buffer.put(Length.getBytes((int)localAttributeLength));
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                    buffer.put((byte)49);
                    int localValuesLength = (Integer)this.valuesLength.get(attributeNumber);
                    buffer.put(Length.getBytes((int)localValuesLength));
                    try {
                        NamingEnumeration<?> values = attribute.getAll();
                        if (values.hasMoreElements()) {
                            while (values.hasMoreElements()) {
                                OctetString value = (OctetString)values.next();
                                Value.encode((ByteBuffer)buffer, (OctetString)value);
                            }
                        }
                    }
                    catch (NamingException ne) {
                        throw new EncoderException("Cannot enumerate the values");
                    }
                    ++attributeNumber;
                }
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException("The PDU buffer size is too small !");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("AddRequest encoding : " + StringUtils.dumpBytes((byte[])buffer.array()));
            log.debug("AddRequest initial value : " + this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Add Request\n");
        sb.append("        Entry : '").append(this.entry.toString()).append("'\n");
        if (this.attributes != null) {
            sb.append("        Attributes\n");
            NamingEnumeration<? extends Attribute> attributesIterator = this.attributes.getAll();
            while (attributesIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributesIterator.nextElement();
                sb.append("           Type : '").append(attribute.getID()).append("'\n");
                for (int j = 0; j < attribute.size(); ++j) {
                    try {
                        OctetString attributeValue = (OctetString)attribute.get(j);
                        sb.append("               Val[").append(j).append("] : ").append(attributeValue.toString()).append(" \n");
                        continue;
                    }
                    catch (NamingException ne) {
                        log.error("Naming exception will printing the '" + attribute.getID() + "'");
                    }
                }
            }
        }
        return sb.toString();
    }
}

