/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.pojo.LdapAuthentication;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.ldap.pojo.SaslCredentials;
import org.apache.asn1new.ldap.pojo.SimpleAuthentication;

public class BindRequest
extends LdapMessage {
    private int version;
    private LdapDN name;
    private LdapAuthentication authentication;
    private transient int bindRequestLength;

    public int getMessageType() {
        return 3;
    }

    public LdapAuthentication getAuthentication() {
        return this.authentication;
    }

    public SimpleAuthentication getSimpleAuthentication() {
        return (SimpleAuthentication)this.authentication;
    }

    public SaslCredentials getSaslAuthentication() {
        return (SaslCredentials)this.authentication;
    }

    public void setAuthentication(LdapAuthentication authentication) {
        this.authentication = authentication;
    }

    public String getName() {
        return this.name == null ? null : this.name.toString();
    }

    public void setName(LdapDN name) {
        this.name = name;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLdapV3() {
        return this.version == 3;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int computeLength() {
        this.bindRequestLength = 3;
        this.bindRequestLength += 1 + Length.getNbBytes((int)this.name.getNbBytes()) + this.name.getNbBytes();
        this.bindRequestLength += this.authentication.computeLength();
        return 1 + Length.getNbBytes((int)this.bindRequestLength) + this.bindRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)96);
            buffer.put(Length.getBytes((int)this.bindRequestLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (int)this.version);
        Value.encode((ByteBuffer)buffer, (byte[])this.name.getBytes());
        this.authentication.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.version).append("'\n");
        sb.append("        Name : '").append(this.name.toString()).append("'\n");
        if (this.authentication instanceof SimpleAuthentication) {
            sb.append("        Simple authentication : '").append(((SimpleAuthentication)this.authentication).toString()).append("'\n");
        } else {
            sb.append(((SaslCredentials)this.authentication).toString());
        }
        return sb.toString();
    }
}

