/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.LdapResponse;
import org.apache.asn1new.primitives.OctetString;

public class BindResponse
extends LdapResponse {
    private OctetString serverSaslCreds;
    private transient int bindResponseLength;

    public int getMessageType() {
        return 4;
    }

    public OctetString getServerSaslCreds() {
        return this.serverSaslCreds;
    }

    public void setServerSaslCreds(OctetString serverSaslCreds) {
        this.serverSaslCreds = serverSaslCreds;
    }

    public int computeLength() {
        int ldapResponseLength;
        this.bindResponseLength = ldapResponseLength = super.computeLength();
        if (this.serverSaslCreds != null) {
            this.bindResponseLength += 1 + Length.getNbBytes((int)this.serverSaslCreds.getNbBytes()) + this.serverSaslCreds.getNbBytes();
        }
        return 1 + Length.getNbBytes((int)this.bindResponseLength) + this.bindResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)97);
            buffer.put(Length.getBytes((int)this.bindResponseLength));
            super.encode(buffer);
            if (this.serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(Length.getBytes((int)this.serverSaslCreds.getNbBytes()));
                if (this.serverSaslCreds.getNbBytes() != 0) {
                    buffer.put(this.serverSaslCreds.getValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    BindResponse\n");
        sb.append(super.toString());
        if (this.serverSaslCreds != null) {
            sb.append("        Server sasl credentials : '").append(this.serverSaslCreds.toString()).append("'\n");
        }
        return sb.toString();
    }
}

