/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.codec.primitives.LdapString;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OctetString;

public class CompareRequest
extends LdapMessage {
    private LdapDN entry;
    private LdapString attributeDesc;
    private OctetString assertionValue;
    private transient int compareRequestLength;
    private transient int avaLength;

    public int getMessageType() {
        return 5;
    }

    public String getEntry() {
        return this.entry == null ? "" : this.entry.getString();
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public void setAssertionValue(OctetString assertionValue) {
        this.assertionValue = assertionValue;
    }

    public String getAttributeDesc() {
        return this.attributeDesc == null ? "" : this.attributeDesc.getString();
    }

    public void setAttributeDesc(LdapString attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public int computeLength() {
        this.compareRequestLength = 1 + Length.getNbBytes((int)this.entry.getNbBytes()) + this.entry.getNbBytes();
        this.avaLength = 1 + Length.getNbBytes((int)this.attributeDesc.getNbBytes()) + this.attributeDesc.getNbBytes() + 1 + Length.getNbBytes((int)this.assertionValue.getNbBytes()) + this.assertionValue.getNbBytes();
        this.compareRequestLength += 1 + Length.getNbBytes((int)this.avaLength) + this.avaLength;
        return 1 + Length.getNbBytes((int)this.compareRequestLength) + this.compareRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)110);
            buffer.put(Length.getBytes((int)this.compareRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.entry.getBytes());
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (String)this.attributeDesc.getString());
        Value.encode((ByteBuffer)buffer, (OctetString)this.assertionValue);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.entry.toString()).append("'\n");
        sb.append("        Attribute description : '").append(this.attributeDesc.toString()).append("'\n");
        sb.append("        Attribute value : '").append(this.assertionValue.toString()).append("'\n");
        return sb.toString();
    }
}

