/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.Asn1Object;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ber.tlv.Value;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;

public class Control
extends Asn1Object {
    private OID controlType;
    private boolean criticality = false;
    private OctetString controlValue;
    private transient int controlLength;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public String getControlType() {
        return this.controlType == null ? "" : this.controlType.toString();
    }

    public void setControlType(OID controlType) {
        this.controlType = controlType;
    }

    public byte[] getControlValue() {
        return this.controlValue == null ? EMPTY_BYTES : this.controlValue.getValue();
    }

    public void setControlValue(OctetString controlValue) {
        this.controlValue = controlValue;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public void setCriticality(boolean criticality) {
        this.criticality = criticality;
    }

    public int computeLength() {
        int controlTypeLengh = this.controlType.getOIDLength();
        this.controlLength = 1 + Length.getNbBytes((int)controlTypeLengh) + controlTypeLengh;
        if (this.criticality) {
            this.controlLength += 3;
        }
        if (this.controlValue != null) {
            this.controlLength += 1 + Length.getNbBytes((int)this.controlValue.getNbBytes()) + this.controlValue.getNbBytes();
        }
        return 1 + Length.getNbBytes((int)this.controlLength) + this.controlLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (OID)this.controlType);
        if (this.criticality) {
            Value.encode((ByteBuffer)buffer, (boolean)this.criticality);
        }
        if (this.controlValue != null) {
            Value.encode((ByteBuffer)buffer, (OctetString)this.controlValue);
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Control\n");
        sb.append("        Control type : '").append(this.controlType.toString()).append("'\n");
        sb.append("        Criticality : '").append(this.criticality).append("'\n");
        if (this.controlValue != null) {
            sb.append("        Control value : '").append(this.controlValue.toString()).append("'\n");
        }
        return sb.toString();
    }
}

