/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.codec.primitives.LdapDN;
import org.apache.asn1new.ldap.pojo.LdapMessage;

public class DelRequest
extends LdapMessage {
    private LdapDN entry;

    public int getMessageType() {
        return 7;
    }

    public String getEntry() {
        return this.entry == null ? "" : this.entry.getString();
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public int computeLength() {
        return 1 + Length.getNbBytes((int)this.entry.getNbBytes()) + this.entry.getNbBytes();
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)74);
            buffer.put(Length.getBytes((int)this.entry.getNbBytes()));
            buffer.put(this.entry.getBytes());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Del request\n");
        sb.append("        Entry : '").append(this.entry.toString()).append("'\n");
        return sb.toString();
    }
}

