/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.LdapResponse;

public class DelResponse
extends LdapResponse {
    public int getMessageType() {
        return 8;
    }

    public int computeLength() {
        int ldapResponseLength = super.computeLength();
        return 1 + Length.getNbBytes((int)ldapResponseLength) + ldapResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)107);
            buffer.put(Length.getBytes((int)this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return super.encode(buffer);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Del Response\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

