/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1new.ldap.pojo;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1new.ber.tlv.Length;
import org.apache.asn1new.ldap.pojo.LdapMessage;
import org.apache.asn1new.primitives.OID;
import org.apache.asn1new.primitives.OctetString;

public class ExtendedRequest
extends LdapMessage {
    private OID requestName;
    private OctetString requestValue;
    private transient int extendedRequestLength;

    public int getMessageType() {
        return 9;
    }

    public String getRequestName() {
        return this.requestName == null ? "" : this.requestName.toString();
    }

    public void setRequestName(OID requestName) {
        this.requestName = requestName;
    }

    public OctetString getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(OctetString requestValue) {
        this.requestValue = requestValue;
    }

    public int computeLength() {
        this.extendedRequestLength = 1 + Length.getNbBytes((int)this.requestName.getOIDLength()) + this.requestName.getOIDLength();
        if (this.requestValue != null) {
            this.extendedRequestLength += 1 + Length.getNbBytes((int)this.requestValue.getNbBytes()) + this.requestValue.getNbBytes();
        }
        return 1 + Length.getNbBytes((int)this.extendedRequestLength) + this.extendedRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)119);
            buffer.put(Length.getBytes((int)this.extendedRequestLength));
            if (this.requestName == null) {
                throw new EncoderException("The request name must not be null");
            }
            buffer.put((byte)-128);
            buffer.put(Length.getBytes((int)this.requestName.getOIDLength()));
            if (this.requestName.getOIDLength() != 0) {
                buffer.put(this.requestName.getOID());
            }
            if (this.requestValue != null) {
                buffer.put((byte)-127);
                buffer.put(Length.getBytes((int)this.requestValue.getNbBytes()));
                if (this.requestValue.getNbBytes() != 0) {
                    buffer.put(this.requestValue.getValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended request\n");
        sb.append("        Request name : '").append(this.requestName.toString()).append("'\n");
        if (this.requestValue != null) {
            sb.append("        Request value : '").append(this.requestValue.toString()).append("'\n");
        }
        return sb.toString();
    }
}

